/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactDecoder
extends BaseSAML2MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);

    public HTTPArtifactDecoder(ParserPool pool) {
        super(pool);
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Override
    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return false;
    }

    @Override
    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        return null;
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        String relayState = DatatypeHelper.safeTrim((String)inTransport.getParameterValue("RelayState"));
        samlMsgCtx.setRelayState(relayState);
        this.processArtifact(samlMsgCtx);
        this.populateMessageContext(samlMsgCtx);
    }

    protected void processArtifact(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        String encodedArtifact = DatatypeHelper.safeTrimOrNullString((String)inTransport.getParameterValue("SAMLart"));
        if (encodedArtifact == null) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL TARGET parameter was missing or did not contain a value.");
        }
    }
}

