/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import edu.harvard.catalyst.scheduler.core.BookedVisitActivityLogStatics;
import edu.harvard.catalyst.scheduler.entity.BookedVisitActivityLog;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScheduledVisitHistoryDTO {
    List<Map<String, String>> bookedVisitActivity;

    public ScheduledVisitHistoryDTO() {
    }

    public ScheduledVisitHistoryDTO(List<BookedVisitActivityLog> bookedVisitActivityLogList) {
        this.bookedVisitActivity = new ArrayList<Map<String, String>>();
        for (BookedVisitActivityLog bookedVisitActivityLogItem : bookedVisitActivityLogList) {
            HashMap<String, String> bookedVisitActivityItemMap = new HashMap<String, String>();
            User user = bookedVisitActivityLogItem.getPerformingUser();
            if (user != null) {
                bookedVisitActivityItemMap.put("user", bookedVisitActivityLogItem.getPerformingUser().getEcommonsId());
            } else {
                bookedVisitActivityItemMap.put("user", null);
            }
            String actionString = bookedVisitActivityLogItem.getActionPerformed();
            BookedVisitActivityLogStatics action = BookedVisitActivityLogStatics.valueByLogString(actionString);
            bookedVisitActivityItemMap.put("action", action.getLogString());
            String formattedDate = DateUtility.format(DateUtility.date24HTime(), bookedVisitActivityLogItem.getDate());
            bookedVisitActivityItemMap.put("date", formattedDate);
            this.bookedVisitActivity.add(bookedVisitActivityItemMap);
        }
    }

    public List<Map<String, String>> getBookedVisitActivity() {
        return this.bookedVisitActivity;
    }
}

