/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.base.Joiner;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Graph;
import java.util.ArrayList;
import java.util.List;

public class ReportTemplateResultDTO {
    private List<String> csvHeaders = new ArrayList<String>();
    private List<List<String>> csvRows = new ArrayList<List<String>>();
    private final String reportName;
    private Graph.QueryScalarsTcfs cachedQsTcfs;

    public ReportTemplateResultDTO(String reportName) {
        this.reportName = reportName;
    }

    public String toCsvString() {
        StringBuilder builder = new StringBuilder();
        if (!this.csvHeaders.isEmpty()) {
            String headers = Joiner.on((String)",").join(this.csvHeaders);
            builder.append(headers).append("\n");
        }
        for (List<String> csvRow : this.csvRows) {
            String row = Joiner.on((String)",").join(csvRow);
            builder.append(row).append("\n");
        }
        return builder.toString();
    }

    public Integer getResultSize() {
        return this.csvRows.size();
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setCsvHeaders(List<String> csvHeaders) {
        this.csvHeaders = csvHeaders;
    }

    public List<String> getCsvHeaders() {
        return this.csvHeaders;
    }

    public List<List<String>> getCsvRows() {
        return this.csvRows;
    }

    public void setCsvRows(List<List<String>> csvRows) {
        this.csvRows = csvRows;
    }

    public Graph.QueryScalarsTcfs getCachedQsTcfs() {
        return this.cachedQsTcfs;
    }

    public void setCachedQsTcfs(Graph.QueryScalarsTcfs cachedQsTcfs) {
        this.cachedQsTcfs = cachedQsTcfs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportTemplateResultDTO that = (ReportTemplateResultDTO)o;
        if (this.csvHeaders != null ? !this.csvHeaders.equals(that.csvHeaders) : that.csvHeaders != null) {
            return false;
        }
        if (this.csvRows != null ? !this.csvRows.equals(that.csvRows) : that.csvRows != null) {
            return false;
        }
        return !(this.reportName != null ? !this.reportName.equals(that.reportName) : that.reportName != null);
    }

    public int hashCode() {
        int result = this.csvHeaders != null ? this.csvHeaders.hashCode() : 0;
        result = 31 * result + (this.csvRows != null ? this.csvRows.hashCode() : 0);
        result = 31 * result + (this.reportName != null ? this.reportName.hashCode() : 0);
        return result;
    }
}

