/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import com.google.common.base.Strings;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class MiscUtil {
    public static final int HASH_MODULUS = 200;

    public static boolean differentObjects(Object one, Object two) {
        boolean result = true;
        if (one == null && two == null) {
            result = false;
        } else if (one != null && one.equals(two)) {
            result = false;
        } else if (two != null && two.equals(one)) {
            result = false;
        }
        return result;
    }

    public static boolean differentStringsIgnoreCase(String one, String two) {
        if (one != null) {
            one = one.toUpperCase();
        }
        if (two != null) {
            two = two.toUpperCase();
        }
        return MiscUtil.differentObjects(one, two);
    }

    public static final <T, F extends Comparable<F>> Comparator<T> compareVia(Function<T, F> fieldGetter) {
        return (o1, o2) -> {
            Comparable field1 = (Comparable)fieldGetter.apply(o1);
            Comparable field2 = (Comparable)fieldGetter.apply(o2);
            if (field1 == null && field2 == null) {
                return 0;
            }
            if (field1 == null) {
                return -1;
            }
            if (field2 == null) {
                return 1;
            }
            return field1.compareTo(field2);
        };
    }

    public static final <T> Comparator<T> invert(Comparator<T> c) {
        return (o1, o2) -> c.compare(o2, o1);
    }

    public static String throwableInfoForLog(Throwable t) {
        String result = " -- " + t.getClass().getSimpleName() + " -- " + t.getMessage();
        return result;
    }

    public static String throwableToStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String applyCodeToXX(String input, String code) {
        String result = input;
        if (code != null) {
            result = result.replaceAll("XX", code);
        }
        return result;
    }

    public static boolean isNonNullNonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNonNullNonEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNonNullNonEmpty(String string) {
        return !Strings.isNullOrEmpty((String)string);
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return !MiscUtil.isNonNullNonEmpty(list);
    }

    public static boolean isNullOrEmpty(String string) {
        return Strings.isNullOrEmpty((String)string);
    }

    public static StringBuilder appendIfDifferentStrings(StringBuilder builder, String oldOne, String newOne, String label) {
        builder.append(label).append(": ");
        if (MiscUtil.differentStringsIgnoreCase(oldOne, newOne)) {
            builder.append(oldOne).append(" --> ").append(newOne);
        } else {
            builder.append(oldOne).append(" (no change)");
        }
        builder.append(". ");
        return builder;
    }

    public static String undefinedToNull(String input) {
        String result = "undefined".equalsIgnoreCase(input) ? null : input;
        return result;
    }

    public static String dbFormatPhoneNumber(String input, boolean keepUnderscores, boolean includeParentheses) {
        String result = null;
        if (input != null) {
            String pattern2;
            String pattern1;
            if (keepUnderscores) {
                pattern1 = "[^\\d^_]";
                pattern2 = "([\\d_]{3})([\\d_]{3})([\\d_]{4})";
            } else {
                pattern1 = "[^\\d]";
                pattern2 = "(\\d{3})(\\d{3})(\\d{4})";
            }
            String format = includeParentheses ? "($1) $2-$3" : "$1-$2-$3";
            result = input.replaceAll(pattern1, "");
            result = result.replaceAll(pattern2, format);
        }
        return result;
    }

    public static SearchDTO.SearchItem preparePhoneNumberSearchItems(SearchDTO.SearchItem searchItem) {
        SearchDTO.SearchType searchType = searchItem.getSearchType() != null ? searchItem.getSearchType() : SearchDTO.SearchType.ANY;
        boolean keepUnderscores = searchType == SearchDTO.SearchType.ANY;
        String key = searchItem.getKey();
        String originalValue = searchItem.getValue();
        String valueWithParentheses = MiscUtil.dbFormatPhoneNumber(originalValue, keepUnderscores, true);
        String valueWithoutParentheses = MiscUtil.dbFormatPhoneNumber(originalValue, keepUnderscores, false);
        SearchDTO.SearchItem orSearchItem1 = new SearchDTO.SearchItem();
        orSearchItem1.setKey(key);
        orSearchItem1.setValue(valueWithoutParentheses);
        orSearchItem1.setSearchType(searchType);
        SearchDTO.SearchItem orSearchItem2 = new SearchDTO.SearchItem();
        orSearchItem2.setKey(key);
        orSearchItem2.setValue(valueWithParentheses);
        orSearchItem2.setSearchType(searchType);
        ArrayList<SearchDTO.SearchItem> orSearchItemList = new ArrayList<SearchDTO.SearchItem>();
        orSearchItemList.add(orSearchItem1);
        orSearchItemList.add(orSearchItem2);
        searchItem.setOrSearchItems(orSearchItemList);
        searchItem.setKey(null);
        searchItem.setValue(null);
        return searchItem;
    }

    public static final <T> Optional<T> nullToEmpty(Optional<T> o) {
        return o != null ? o : Optional.empty();
    }

    public static int moduloMinsPerHour(int totalMinutes) {
        return MiscUtil.multiDayMinutesToHourlyMinute(totalMinutes);
    }

    public static int divideByMinsPerHour(int totalMinutes) {
        return totalMinutes / 60;
    }

    public static int divideByMinsPerDay(int totalMinutes) {
        return totalMinutes / 1440;
    }

    public static int multiDayMinutesToHourlyMinute(int slotOffsetEndMinute) {
        return slotOffsetEndMinute % 60;
    }

    public static int multiDayMinutesToDailyHour(int slotOffsetStartMinute) {
        return slotOffsetStartMinute % 1440 / 60;
    }

    public static String localDate2LaterThanDate1YesNo(Date date1, Date date2) {
        LocalDate ldate1 = DateUtility.dateToLocalDate(date1);
        LocalDate ldate2 = DateUtility.dateToLocalDate(date2);
        String result = ldate2.isAfter(ldate1) ? "YES" : "NO";
        return result;
    }

    public static String endMinusStartInMinutes(Date start, Date end) {
        if (start == null || end == null) {
            return "";
        }
        long millisDiff = end.getTime() - start.getTime();
        long minutesDiff = millisDiff / 60000L;
        return String.valueOf(minutesDiff);
    }

    public static String formatEndMinusStart(Date start, Date end) {
        if (start == null || end == null) {
            return "";
        }
        long millisDiff = end.getTime() - start.getTime();
        if (millisDiff < 0L) {
            return "";
        }
        long minutesDiff = millisDiff / 60000L;
        long daysDiff = minutesDiff / 1440L;
        int remainingMinsInDay = (int)(minutesDiff % 1440L);
        int remainingHoursInDay = remainingMinsInDay / 60;
        int remainingMinsInHour = remainingMinsInDay % 60;
        String result = MiscUtil.formatDaysHrsMins(daysDiff, remainingHoursInDay, remainingMinsInHour);
        return result;
    }

    public static String formatDaysHrsMins(long days, int hours, int minutes) {
        String result = MiscUtil.formatNoneOneOrMore(days, "Day") + MiscUtil.formatNoneOneOrMore(hours, "Hr") + MiscUtil.formatNoneOneOrMore(minutes, "Min");
        if ((result = result.trim()).isEmpty()) {
            result = "0 Mins";
        }
        return result;
    }

    public static String formatMinsIntoDaysHrsMins(Integer timeInMinutes) {
        if (timeInMinutes != null) {
            int timeDiffInDays = timeInMinutes / 1440;
            int remainingMinutesInDay = timeInMinutes % 1440;
            int remainingHoursInDay = remainingMinutesInDay / 60;
            int remainingMinutesInHour = remainingMinutesInDay % 60;
            return MiscUtil.formatDaysHrsMins(timeDiffInDays, remainingHoursInDay, remainingMinutesInHour);
        }
        return "";
    }

    static String formatNoneOneOrMore(long value, String singular) {
        String result = value < 0L ? "Many " + singular + "s " : (value == 0L ? "" : (value == 1L ? String.valueOf(value) + " " + singular + " " : String.valueOf(value) + " " + singular + "s "));
        return result;
    }

    public static String showDateTime(Date raw) {
        String result = DateUtility.format(DateUtility.date24HTime(), raw);
        return MiscUtil.nullToEmptyString(result);
    }

    public static String showDate(Date raw) {
        String result = DateUtility.format(DateUtility.monthDayYear(), raw);
        return MiscUtil.nullToEmptyString(result);
    }

    public static String yesNoValue(Boolean value) {
        String result = value == null ? "" : (value != false ? "Yes" : "No");
        return result;
    }

    public static String nullToEmptyString(String raw) {
        return raw != null ? raw : "";
    }

    public static String booleanToStatusValue(String raw) {
        if ((raw = MiscUtil.nullToEmptyString(raw)).trim().equalsIgnoreCase("true")) {
            return "Active";
        }
        return "Not Active";
    }

    public static String fullName(String first, String middle, String last) {
        String result = MiscUtil.nullToEmptyString(first) + " " + MiscUtil.nullToEmptyString(middle) + " " + MiscUtil.nullToEmptyString(last);
        result = result.replaceAll("\\s+", " ");
        return result.trim();
    }

    public static String q(String raw) {
        raw = MiscUtil.nullToEmptyString(raw);
        raw = raw.replaceAll(",", " ");
        raw = raw.replaceAll("\"", "");
        return "\"" + raw + "\"";
    }

    public static String q(Number raw) {
        String result = "";
        if (raw != null) {
            result = String.valueOf(raw);
        }
        return "\"" + result + "\"";
    }
}

