/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.metadata;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.SimpleURLCanonicalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.metadata.MetadataMemoryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class MetadataGeneratorFilter
extends GenericFilterBean {
    protected static final Logger log = LoggerFactory.getLogger(MetadataGeneratorFilter.class);
    protected MetadataManager manager;
    protected MetadataGenerator generator;
    protected MetadataDisplayFilter displayFilter;
    protected boolean normalizeBaseUrl;
    private static final String DEFAULT_ALIAS = "defaultAlias";

    public MetadataGeneratorFilter(MetadataGenerator generator) {
        this.generator = generator;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.processMetadataInitialization((HttpServletRequest)request);
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMetadataInitialization(HttpServletRequest request) throws ServletException {
        if (this.manager.getHostedSPName() != null) return;
        Class<MetadataManager> clazz = MetadataManager.class;
        synchronized (MetadataManager.class) {
            if (this.manager.getHostedSPName() != null) return;
            try {
                log.info("No default metadata configured, generating with default values, please pre-configure metadata for production use");
                String alias = this.generator.getEntityAlias();
                String baseURL = this.getDefaultBaseURL(request);
                if (this.generator.getEntityBaseURL() == null) {
                    log.warn("Generated default entity base URL {} based on values in the first server request. Please set property entityBaseURL on MetadataGenerator bean to fixate the value.", (Object)baseURL);
                    this.generator.setEntityBaseURL(baseURL);
                } else {
                    baseURL = this.generator.getEntityBaseURL();
                }
                if (this.generator.getEntityId() == null) {
                    this.generator.setEntityId(this.getDefaultEntityID(baseURL, alias));
                }
                EntityDescriptor descriptor = this.generator.generateMetadata();
                ExtendedMetadata extendedMetadata = this.generator.generateExtendedMetadata();
                log.info("Created default metadata for system with entityID: " + descriptor.getEntityID());
                MetadataMemoryProvider memoryProvider = new MetadataMemoryProvider(descriptor);
                memoryProvider.initialize();
                ExtendedMetadataDelegate metadataProvider = new ExtendedMetadataDelegate((MetadataProvider)memoryProvider, extendedMetadata);
                this.manager.addMetadataProvider((MetadataProvider)metadataProvider);
                this.manager.setHostedSPName(descriptor.getEntityID());
                this.manager.refreshMetadata();
            }
            catch (MetadataProviderException e) {
                log.error("Error generating system metadata", (Throwable)e);
                throw new ServletException("Error generating system metadata", (Throwable)e);
            }
            return;
        }
    }

    protected String getDefaultEntityID(String entityBaseUrl, String alias) {
        String displayFilterUrl = "/saml/metadata";
        if (this.displayFilter != null) {
            displayFilterUrl = this.displayFilter.getFilterProcessesUrl();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entityBaseUrl);
        sb.append(displayFilterUrl);
        if (StringUtils.hasLength((String)alias)) {
            sb.append("/alias/");
            sb.append(alias);
        }
        return sb.toString();
    }

    protected String getDefaultBaseURL(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
        sb.append(request.getContextPath());
        String url = sb.toString();
        if (this.isNormalizeBaseUrl()) {
            return SimpleURLCanonicalizer.canonicalize((String)url);
        }
        return url;
    }

    @Autowired(required=false)
    public void setDisplayFilter(MetadataDisplayFilter displayFilter) {
        this.displayFilter = displayFilter;
    }

    @Autowired
    public void setManager(MetadataManager manager) {
        this.manager = manager;
    }

    public boolean isNormalizeBaseUrl() {
        return this.normalizeBaseUrl;
    }

    public void setNormalizeBaseUrl(boolean normalizeBaseUrl) {
        this.normalizeBaseUrl = normalizeBaseUrl;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.generator, (String)"Metadata generator");
        Assert.notNull((Object)this.manager, (String)"MetadataManager must be set");
    }
}

