/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Vertex;
import java.util.List;

public class Edge
implements Comparable {
    private final Vertex pointOne;
    private final Vertex pointTwo;
    private final JoinType joinType;
    private String join;

    public Edge(Vertex pointOne, Vertex pointTwo, JoinType joinType, String joinField) {
        this(pointOne, pointTwo, joinType, joinField, JoinAssembly.leftField);
    }

    public Edge(Vertex pointOne, Vertex pointTwo, JoinType joinType, String joinField, JoinAssembly joinAssembly) {
        this.pointOne = pointOne;
        this.pointTwo = pointTwo;
        this.joinType = joinType;
        this.setJoinFromCtor(joinField, pointOne, pointTwo, joinAssembly);
    }

    void setJoinFromCtor(String joinField, Vertex pointOne, Vertex pointTwo, JoinAssembly joinAssembly) {
        String lhs = pointOne.getTableShortName();
        String rhs = pointTwo.getTableShortName();
        this.join = joinAssembly.assembled(lhs, rhs, joinField);
    }

    public Vertex getPointTwo() {
        return this.pointTwo;
    }

    public Vertex getPointOne() {
        return this.pointOne;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    void produceJoinLists(List<String> whereClauseList, boolean previousLeftJoin, Vertex previousRhs, StringBuilder builder, List<String> fromTables) {
        if (this.getJoinType().equals((Object)JoinType.INNER)) {
            String tableName = this.pointTwo.fullName();
            fromTables.add(tableName);
            whereClauseList.add(this.getJoin());
        } else if (this.getJoinType().equals((Object)JoinType.LEFT)) {
            if (!previousLeftJoin && previousRhs != null) {
                if (!builder.toString().contains(" INNER JOIN " + previousRhs.fullName())) {
                    builder.append(" INNER JOIN ").append(previousRhs.fullName());
                }
                whereClauseList.remove(previousRhs.fullName());
                fromTables.remove(previousRhs.fullName());
            }
            builder.append(" ").append((Object)this.getJoinType()).append(" ").append(this.getPointTwo().fullName()).append(" on ").append(this.getJoin());
        } else {
            SchedulerRuntimeException.logAndThrow("Sorry, supporting only INNER and LEFT joins.");
        }
    }

    public String getJoin() {
        return this.join;
    }

    public String toString() {
        return this.pointOne + " <- (" + this.joinType + ") " + this.join + " -> " + this.pointTwo;
    }

    public int compareTo(Object obj) {
        Integer otherOne;
        Edge other = (Edge)obj;
        if (other == null) {
            return 1;
        }
        Integer thisOne = this.getPointOne().getPriority();
        int compare1 = thisOne.compareTo(otherOne = Integer.valueOf(other.getPointOne().getPriority()));
        if (compare1 != 0) {
            return compare1;
        }
        thisOne = this.getPointTwo().getPriority();
        otherOne = other.getPointTwo().getPriority();
        return thisOne.compareTo(otherOne);
    }

    public static enum JoinAssembly {
        leftField{

            @Override
            String assembled(String lhs, String rhs, String joinField) {
                return lhs + "." + joinField + " = " + rhs + ".id";
            }
        }
        ,
        rightField{

            @Override
            String assembled(String lhs, String rhs, String joinField) {
                return rhs + "." + joinField + " = " + lhs + ".id";
            }
        }
        ,
        wholeField{

            @Override
            String assembled(String lhs, String rhs, String joinField) {
                return joinField;
            }
        };


        abstract String assembled(String var1, String var2, String var3);
    }

    public static enum JoinType {
        INNER("inner join"),
        LEFT("left join"),
        RIGHT("right join");

        private String display;

        private JoinType(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }
}

