/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SubjectVisitHistoryReportDTO
implements CsvAbleDTO {
    private String subjectLastName;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String mrn;
    private String localId;
    private String visitName;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private Date cancelDate;
    private Date checkInDate;
    private Date checkOutDate;
    private String appointmentStatus;
    private String cancelStatusReason;

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public void setAppointmentStatus(String appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public Date getCancelDate() {
        return this.cancelDate;
    }

    public void setCancelDate(Date cancelDate) {
        this.cancelDate = cancelDate;
    }

    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    public Date getCheckOutDate() {
        return this.checkOutDate;
    }

    public void setCheckOutDate(Date checkOutDate) {
        this.checkOutDate = checkOutDate;
    }

    public String getCancelStatusReason() {
        return this.cancelStatusReason;
    }

    public void setCancelStatusReason(String cancelStatusReason) {
        this.cancelStatusReason = cancelStatusReason;
    }

    @Override
    public String toCsvHeaders() {
        return "Subject Name,MRN,Visit Name,Scheduled Visit Start Time,Scheduled Visit End Time,Appointment Status,Local ID, Cancel Date, Cancel Status Reason, Check In Date, Check Out Date";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        String previousSubjectId = null;
        for (Object object : dtoList) {
            SubjectVisitHistoryReportDTO d = (SubjectVisitHistoryReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            String currentSubjectId = d.mrn;
            if (!currentSubjectId.equals(previousSubjectId)) {
                result.add(this.toCsvHeaders() + "\n");
                previousSubjectId = currentSubjectId;
            }
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.appointmentStatus));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.cancelDate)));
            columns.add(MiscUtil.q(d.cancelStatusReason));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInDate)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkOutDate)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

