/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BillableResourcesReportDTO
implements CsvAbleDTO {
    private Integer resourceId;
    private String resourceName;
    private Date checkInTime;
    private Date checkOutTime;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String genderName;
    private Boolean industryInitiated;
    private Boolean crcFunded;
    private String sublocationName;
    private String studyName;
    private String catalystId;
    private String localId;
    private String irb;
    private String piFirstName;
    private String piMiddleName;
    private String piLastName;
    private String visitName;
    private String visitTypeName;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String bookedVisitComment;
    private String resourceActivities;
    private String resourceActivitiesComment;
    private String resourceActivitiesQuantity;

    public Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public void setGenderName(String genderName) {
        this.genderName = genderName;
    }

    public Boolean getIndustryInitiated() {
        return this.industryInitiated;
    }

    public void setIndustryInitiated(Boolean industryInitiated) {
        this.industryInitiated = industryInitiated;
    }

    public String getSublocationName() {
        return this.sublocationName;
    }

    public void setSublocationName(String sublocationName) {
        this.sublocationName = sublocationName;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getPiFirstName() {
        return this.piFirstName;
    }

    public void setPiFirstName(String piFirstName) {
        this.piFirstName = piFirstName;
    }

    public String getPiMiddleName() {
        return this.piMiddleName;
    }

    public void setPiMiddleName(String piMiddleName) {
        this.piMiddleName = piMiddleName;
    }

    public String getPiLastName() {
        return this.piLastName;
    }

    public void setPiLastName(String piLastName) {
        this.piLastName = piLastName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getVisitTypeName() {
        return this.visitTypeName;
    }

    public void setVisitTypeName(String visitTypeName) {
        this.visitTypeName = visitTypeName;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getBookedVisitComment() {
        return this.bookedVisitComment;
    }

    public void setBookedVisitComment(String bookedVisitComment) {
        this.bookedVisitComment = bookedVisitComment;
    }

    public Boolean getCrcFunded() {
        return this.crcFunded;
    }

    public void setCrcFunded(Boolean crcFunded) {
        this.crcFunded = crcFunded;
    }

    public String getResourceActivities() {
        return this.resourceActivities;
    }

    public void setResourceActivities(String resourceActivities) {
        this.resourceActivities = resourceActivities;
    }

    public String getResourceActivitiesComment() {
        return this.resourceActivitiesComment;
    }

    public void setResourceActivitiesComment(String resourceActivitiesComment) {
        this.resourceActivitiesComment = resourceActivitiesComment;
    }

    public String getResourceActivitiesQuantity() {
        return this.resourceActivitiesQuantity;
    }

    public void setResourceActivitiesQuantity(String resourceActivitiesQuantity) {
        this.resourceActivitiesQuantity = resourceActivitiesQuantity;
    }

    @Override
    public String toCsvHeaders() {
        return "Resource Name,Check In,Check Out,Visit Duration,Study Subject,MRN,Industry Initiated,CRC Approved Study,Sublocation,Study Name,Catalyst ID,Local ID,IRB #,PI,Visit Name,Visit Type,Resource Start Time,Resource End Time, Booked Resource Activities, Booked Resource Activities Comment, Booked Resource Activities Quantity, Booked Visit Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            BillableResourcesReportDTO d = (BillableResourcesReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkOutTime)));
            columns.add(MiscUtil.formatEndMinusStart(d.checkInTime, d.checkOutTime));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.industryInitiated)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.crcFunded)));
            columns.add(MiscUtil.q(d.sublocationName));
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.piFirstName, d.piMiddleName, d.piLastName)));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitTypeName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.resourceActivities));
            columns.add(MiscUtil.q(d.resourceActivitiesComment));
            columns.add(MiscUtil.q(d.resourceActivitiesQuantity));
            columns.add(MiscUtil.q(d.bookedVisitComment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

