/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.query.Query;

class CriteriaQueryHelper {
    private CriteriaBuilder builder;
    private CriteriaQuery criteria;
    private Root root;
    private Session session;
    List<Predicate> predicates = Lists.newArrayList();

    CriteriaQueryHelper(Session session, Class<? extends BaseEntity> entityClass) {
        this.session = session;
        this.builder = session.getCriteriaBuilder();
        this.criteria = this.builder.createQuery(entityClass);
        this.root = this.criteria.from(entityClass);
        this.criteria.select((Selection)this.root);
    }

    void whereEquals(String propertyName, Object value) {
        Predicate predicate = this.builder.equal((Expression)this.root.get(propertyName), value);
        this.predicates.add(predicate);
    }

    void whereIsNull(String propertyName) {
        Predicate predicate = this.builder.isNull((Expression)this.root.get(propertyName));
        this.predicates.add(predicate);
    }

    void whereLike(String propertyName, String likeness) {
        Predicate predicate = this.builder.like((Expression)this.root.get(propertyName), likeness);
        this.predicates.add(predicate);
    }

    void whereIn(String propertyName, List<?> candidateList) {
        Path nameExpression = this.root.get(propertyName);
        Predicate predicate = nameExpression.in(candidateList);
        this.predicates.add(predicate);
    }

    void orderAsc(String propertyName) {
        this.criteria.orderBy(new Order[]{this.builder.asc((Expression)this.root.get(propertyName))});
    }

    void orderDesc(String propertyName) {
        this.criteria.orderBy(new Order[]{this.builder.desc((Expression)this.root.get(propertyName))});
    }

    Query getQuery() {
        if (!this.predicates.isEmpty()) {
            Predicate[] predicateArray = this.predicates.toArray(new Predicate[this.predicates.size()]);
            this.criteria.where(predicateArray);
        }
        Query query = this.session.createQuery(this.criteria);
        return query;
    }
}

