/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import java.util.function.Function;

public final class Pair<A, B> {
    public final A first;
    public final B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public <A1, B1> Pair<A1, B1> transform(Function<A, A1> f, Function<B, B1> g) {
        return Pair.pair(f.apply(this.first), g.apply(this.second));
    }

    public <A1> Pair<A1, B> transformFirst(Function<A, A1> f) {
        return Pair.pair(f.apply(this.first), this.second);
    }

    public <B1> Pair<A, B1> transformSecond(Function<B, B1> g) {
        return Pair.pair(this.first, g.apply(this.second));
    }

    public static <A, B> Pair<A, B> pair(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public String toString() {
        return "Pair [first=" + this.first + ", second=" + this.second + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }
}

