/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import java.util.List;

public final class AnnotationsNamesQuantityCommentResponseDTO {
    private final List<AnnotationNames> annotationsStore;

    AnnotationsNamesQuantityCommentResponseDTO(List<AnnotationNames> annotationNamesList) {
        this.annotationsStore = annotationNamesList;
    }

    public static AnnotationsNamesQuantityCommentResponseDTO fromAnnotationsList(List<LineLevelAnnotations> lineLevelAnnotationsList) {
        List annotationNamesList = RichList.enrich(lineLevelAnnotationsList).map(llas -> new AnnotationNames((LineLevelAnnotations)llas)).toList();
        return new AnnotationsNamesQuantityCommentResponseDTO(annotationNamesList);
    }

    public static final class AnnotationNames {
        private final Integer id;
        private final String name;
        private final int quantity;
        private final boolean quantifiable;
        private final String comment;

        AnnotationNames(LineLevelAnnotations annotations) {
            if (annotations == null) {
                SchedulerRuntimeException.logAndThrow("LineLevelAnnotations parameter should be non-null");
            }
            this.id = annotations.getId();
            this.name = annotations.getName();
            this.quantity = annotations.getQuantity();
            this.quantifiable = annotations.isQuantifiable();
            this.comment = annotations.getComment();
        }
    }
}

