/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CancellationsReportResponseDTO
implements CsvAbleDTO {
    private String asrName;
    private Date cancelDate;
    private String cancelStatus;
    private String catalystId;
    private String irb;
    private String localId;
    private String mrn;
    private String piFirstName;
    private String piMiddleName;
    private String piLastName;
    private Date scheduledDate;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String studyName;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String userEcommonsId;
    private String visitName;
    private String visitTypeName;

    public CancellationsReportResponseDTO(BookedVisit bookedVisit) {
        Study study;
        if (bookedVisit == null) {
            SchedulerRuntimeException.logAndThrow("BookedVisit parameter should be non-null");
        }
        if ((study = bookedVisit.getStudy()) == null) {
            SchedulerRuntimeException.logAndThrow("Study field of BookedVisit parameter should be non-null");
        }
        this.asrName = bookedVisit.getCancelStatusReason().getName();
        this.cancelDate = bookedVisit.getCancelDate();
        this.cancelStatus = "";
        if (bookedVisit.getCancelStatus() != null) {
            this.cancelStatus = bookedVisit.getCancelStatus().getName();
        }
        this.catalystId = "";
        if (study.getCatalystId() != null) {
            this.catalystId = study.getCatalystId();
        }
        this.irb = "";
        if (study.getIrb() != null) {
            this.irb = study.getIrb();
        }
        this.localId = study.getLocalId();
        User investigator = study.getInvestigator();
        if (investigator != null) {
            this.piFirstName = study.getInvestigator().getFirstName();
            this.piMiddleName = study.getInvestigator().getMiddleName();
            this.piLastName = study.getInvestigator().getLastName();
        } else {
            this.piFirstName = "";
            this.piMiddleName = "";
            this.piLastName = "N/A";
        }
        this.scheduledDate = bookedVisit.getSchedulingTime();
        this.scheduledStartTime = bookedVisit.getScheduledStartTime();
        this.scheduledEndTime = bookedVisit.getScheduledEndTime();
        this.studyName = study.getName();
        SubjectMrn subjectMrn = bookedVisit.getSubjectMrnDecrypted();
        this.subjectFirstName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getFirstName();
        this.subjectMiddleName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getMiddleName();
        this.subjectLastName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getLastName();
        this.mrn = subjectMrn == null ? "N/A" : subjectMrn.getMrn();
        this.userEcommonsId = bookedVisit.getSchedulingUser().getEcommonsId();
        this.visitName = bookedVisit.getVisitTemplate().getName();
        this.visitTypeName = bookedVisit.getVisitTemplate().getVisitType().getName();
    }

    @Override
    public String toCsvHeaders() {
        return "Study Name,Catalyst ID,Local ID,IRB #,PI Name,Subject,MRN,Visit Name,Visit Type,Visit Start Time,Visit End Time,Visit Length,Scheduled Date,Cancel Date,Reason,Cancellation Type,User";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            CancellationsReportResponseDTO d = (CancellationsReportResponseDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.piFirstName, d.piMiddleName, d.piLastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitTypeName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledDate)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.cancelDate)));
            columns.add(MiscUtil.q(d.asrName));
            columns.add(MiscUtil.q(d.cancelStatus));
            columns.add(MiscUtil.q(d.userEcommonsId));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

