/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CensusReportDTO
implements CsvAbleDTO {
    private Integer asrId;
    private Integer studyId;
    private Integer visitId;
    private String asrName;
    private String studyName;
    private String piFirstName;
    private String piMiddleName;
    private String piLastName;
    private String psFirstName;
    private String psMiddleName;
    private String psLastName;
    private String catalystId;
    private String localId;
    private String irb;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String visitName;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String visitType;
    private Boolean industryInitiated;
    private String sublocation;

    public Integer getAsrId() {
        return this.asrId;
    }

    public void setAsrId(Integer asrId) {
        this.asrId = asrId;
    }

    public Integer getStudyId() {
        return this.studyId;
    }

    public void setStudyId(Integer studyId) {
        this.studyId = studyId;
    }

    public String getAsrName() {
        return this.asrName;
    }

    public void setAsrName(String asrName) {
        this.asrName = asrName;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getPiFirstName() {
        return this.piFirstName;
    }

    public void setPiFirstName(String piFirstName) {
        this.piFirstName = piFirstName;
    }

    public String getPiMiddleName() {
        return this.piMiddleName;
    }

    public void setPiMiddleName(String piMiddleName) {
        this.piMiddleName = piMiddleName;
    }

    public String getPiLastName() {
        return this.piLastName;
    }

    public void setPiLastName(String piLastName) {
        this.piLastName = piLastName;
    }

    public String getPsFirstName() {
        return this.psFirstName;
    }

    public void setPsFirstName(String psFirstName) {
        this.psFirstName = psFirstName;
    }

    public String getPsMiddleName() {
        return this.psMiddleName;
    }

    public void setPsMiddleName(String psMiddleName) {
        this.psMiddleName = psMiddleName;
    }

    public String getPsLastName() {
        return this.psLastName;
    }

    public void setPsLastName(String psLastName) {
        this.psLastName = psLastName;
    }

    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public Boolean getIndustryInitiated() {
        return this.industryInitiated;
    }

    public void setIndustryInitiated(Boolean industryInitiated) {
        this.industryInitiated = industryInitiated;
    }

    public Integer getVisitId() {
        return this.visitId;
    }

    public void setVisitId(Integer visitId) {
        this.visitId = visitId;
    }

    public String getSublocation() {
        return this.sublocation;
    }

    public void setSublocation(String sublocation) {
        this.sublocation = sublocation;
    }

    @Override
    public String toCsvHeaders() {
        return "Reason Name,Study Name,PI Name,Primary Scheduling Contact,Catalyst ID,Local ID,IRB #,Industry Initiated,Check In Date,Check Out Date,# Days Over Midnight,Visit ID,Visit Length,Visit Length total Minutes,Visit Name, Sub-Location, Visit Type,Study Subject,MRN";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            CensusReportDTO d = (CensusReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.asrName));
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.piFirstName, d.piMiddleName, d.piLastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.psFirstName, d.psMiddleName, d.psLastName)));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.industryInitiated)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(DateUtility.overnightsBetweenDates(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.visitId));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.endMinusStartInMinutes(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.sublocation));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

