/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.persistence.ReportDAO;
import edu.harvard.catalyst.scheduler.persistence.UserRoleType;
import java.util.Optional;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public enum UserDataReportFilterStrategy {
    LASTNAME(1){

        @Override
        public Criterion makeCriterion(ReportDAO dao, String filterString) {
            return Restrictions.like((String)"lastName", (Object)filterString);
        }
    }
    ,
    INSTITUTION_ROLE(2){

        @Override
        public Criterion makeCriterion(ReportDAO dao, String filterString) {
            InstitutionRoleType institutionRoleType = (InstitutionRoleType)InstitutionRoleType.fromHumanReadableName(filterString).orNull();
            InstitutionRole ap = dao.findInstitutionRoleByType(institutionRoleType);
            return Restrictions.eq((String)"institutionRole", (Object)ap);
        }
    }
    ,
    ROLE(3){

        @Override
        public Criterion makeCriterion(ReportDAO dao, String filterString) {
            Optional<UserRoleType> roleOption = UserRoleType.fromHumanReadableName(filterString);
            Integer id = roleOption.isPresent() ? Integer.valueOf(roleOption.get().databaseId) : null;
            Role ap = dao.findById(Role.class, id);
            return Restrictions.eq((String)"role", (Object)ap);
        }
    }
    ,
    IS_ACTIVE(4){

        @Override
        public Criterion makeCriterion(ReportDAO dao, String filterString) {
            return Restrictions.eq((String)"active", (Object)Boolean.TRUE);
        }
    }
    ,
    IS_NOT_ACTIVE(5){

        @Override
        public Criterion makeCriterion(ReportDAO dao, String filterString) {
            return Restrictions.eq((String)"active", (Object)Boolean.FALSE);
        }
    };

    @Deprecated
    public final int databaseId;

    public abstract Criterion makeCriterion(ReportDAO var1, String var2);

    private UserDataReportFilterStrategy(int databaseId) {
        this.databaseId = databaseId;
    }

    public static Optional<UserDataReportFilterStrategy> fromIdString(String idString) {
        for (UserDataReportFilterStrategy strategy : UserDataReportFilterStrategy.values()) {
            if (!String.valueOf(strategy.databaseId).equals(idString)) continue;
            return Optional.of(strategy);
        }
        return Optional.empty();
    }
}

