/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SearchAlgorithmDAO
extends SiteDAO {
    public List<TemplateResourceGroup> getTemplateResourceGroups(VisitTemplate selectedVisit, boolean flexVsFloat) {
        String findTemplateResourceGroups = "SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ";
        Query query = this.newQuery("SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ");
        query.setParameter("visit", (Object)selectedVisit);
        query.setParameter("flexGroup", (Object)flexVsFloat);
        return query.list();
    }

    public List<TemplateResource> getSingleFloatTemplateResources(VisitTemplate selectedVisit) {
        String findFloatTemplateResource = "SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ");
        query.setParameter("visit", (Object)selectedVisit);
        return query.list();
    }

    public boolean isSublocationClosed(Sublocation sublocation, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocation);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List list = query.list();
        return !list.isEmpty();
    }

    public List<BookedResource> findOverbookConflictResourcesByVisitStatus(Resource resource, Date startDate, Date endDate) {
        String findBookedResource = "select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime";
        Query query = this.newQuery("select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }
}

