/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.security.Key;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.KeyLengthCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyLengthCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyLengthCredentialCriteria.class);
    private Integer keyLength;

    public EvaluableKeyLengthCredentialCriteria(KeyLengthCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.keyLength = criteria.getKeyLength();
    }

    public EvaluableKeyLengthCredentialCriteria(Integer newKeyLength) {
        if (newKeyLength == null) {
            throw new IllegalArgumentException("Key length may not be null");
        }
        this.keyLength = newKeyLength;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return null;
        }
        Integer length = SecurityHelper.getKeyLength(key);
        if (length == null) {
            this.log.info("Could not evaluate criteria, can not determine length of key");
            return null;
        }
        Boolean result = this.keyLength.equals(length);
        return result;
    }

    private Key getKey(Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }
}

