/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import java.util.Locale;
import org.hibernate.FlushMode;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.SessionFactoryRegistry;
import org.jboss.logging.Logger;

public class Helper {
    private static final Logger log = Logger.getLogger(Helper.class);
    private final Consumer consumer;

    public Helper(Consumer consumer) {
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T performWork(LazyInitializationWork<T> lazyInitializationWork) {
        SharedSessionContractImplementor session = this.consumer.getLinkedSession();
        boolean isTempSession = false;
        boolean isJta = false;
        if (session == null) {
            if (this.consumer.allowLoadOutsideTransaction()) {
                session = this.openTemporarySessionForLoading(lazyInitializationWork);
                isTempSession = true;
            } else {
                this.throwLazyInitializationException(Cause.NO_SESSION, lazyInitializationWork);
            }
        } else if (!session.isOpen()) {
            if (this.consumer.allowLoadOutsideTransaction()) {
                session = this.openTemporarySessionForLoading(lazyInitializationWork);
                isTempSession = true;
            } else {
                this.throwLazyInitializationException(Cause.CLOSED_SESSION, lazyInitializationWork);
            }
        } else if (!session.isConnected()) {
            if (this.consumer.allowLoadOutsideTransaction()) {
                session = this.openTemporarySessionForLoading(lazyInitializationWork);
                isTempSession = true;
            } else {
                this.throwLazyInitializationException(Cause.DISCONNECTED_SESSION, lazyInitializationWork);
            }
        }
        if (isTempSession && !(isJta = session.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta())) {
            session.beginTransaction();
        }
        try {
            T t = lazyInitializationWork.doWork(session, isTempSession);
            return t;
        }
        finally {
            if (isTempSession) {
                try {
                    if (!isJta) {
                        session.getTransaction().commit();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to commit JDBC transaction on temporary session used to load lazy collection associated to no session");
                }
                try {
                    session.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to close temporary session used to load lazy collection associated to no session");
                }
            }
        }
    }

    private void throwLazyInitializationException(Cause cause, LazyInitializationWork work) {
        String reason;
        switch (cause) {
            case NO_SESSION: {
                reason = "no session and settings disallow loading outside the Session";
                break;
            }
            case CLOSED_SESSION: {
                reason = "session is closed and settings disallow loading outside the Session";
                break;
            }
            case DISCONNECTED_SESSION: {
                reason = "session is disconnected and settings disallow loading outside the Session";
                break;
            }
            case NO_SF_UUID: {
                reason = "could not determine SessionFactory UUId to create temporary Session for loading";
                break;
            }
            default: {
                reason = "<should never get here>";
            }
        }
        String message = String.format(Locale.ROOT, "Unable to perform requested lazy initialization [%s.%s] - %s", work.getEntityName(), work.getAttributeName(), reason);
        throw new LazyInitializationException(message);
    }

    private SharedSessionContractImplementor openTemporarySessionForLoading(LazyInitializationWork lazyInitializationWork) {
        if (this.consumer.getSessionFactoryUuid() == null) {
            this.throwLazyInitializationException(Cause.NO_SF_UUID, lazyInitializationWork);
        }
        SessionFactoryImplementor sf = (SessionFactoryImplementor)SessionFactoryRegistry.INSTANCE.getSessionFactory(this.consumer.getSessionFactoryUuid());
        SharedSessionContractImplementor session = (SharedSessionContractImplementor)((Object)sf.openSession());
        session.getPersistenceContext().setDefaultReadOnly(true);
        session.setHibernateFlushMode(FlushMode.MANUAL);
        return session;
    }

    static enum Cause {
        NO_SESSION,
        CLOSED_SESSION,
        DISCONNECTED_SESSION,
        NO_SF_UUID;

    }

    static interface LazyInitializationWork<T> {
        public T doWork(SharedSessionContractImplementor var1, boolean var2);

        public String getEntityName();

        public String getAttributeName();
    }

    static interface Consumer {
        public SharedSessionContractImplementor getLinkedSession();

        public boolean allowLoadOutsideTransaction();

        public String getSessionFactoryUuid();
    }
}

