/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.importSubjectMrns;

import com.google.common.collect.Sets;
import com.opencsv.CSVReader;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.importSubjectMrns.ImportSubjectMrns;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.util.FactoryMockKey;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.AssertionErrors;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportMrnsTest {
    SubjectDAO subjectDAO = (SubjectDAO)Mockito.mock(SubjectDAO.class);
    Subject subject1 = (Subject)Mockito.mock(Subject.class);
    Subject subject2 = (Subject)Mockito.mock(Subject.class);
    Subject subject3 = (Subject)Mockito.mock(Subject.class);
    Subject subject4 = (Subject)Mockito.mock(Subject.class);
    Key key;
    ImportSubjectMrns importSubjectMrns;

    CSVReader getCsvReader(String filenameOnClasspath) throws UnsupportedEncodingException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(filenameOnClasspath);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        CSVReader csvReader = new CSVReader((Reader)bufferedReader);
        return csvReader;
    }

    @Before
    public void setup() {
        FactoryMockKey keyFactory = new FactoryMockKey();
        this.key = keyFactory.createKey();
        SubjectDataEncryptor.setEncryptionKey((Key)this.key);
        this.importSubjectMrns = new ImportSubjectMrns(this.subjectDAO, this.key);
        this.importSubjectMrns.loadIndices(0, 1, 2, 3, 4);
        this.importSubjectMrns.setClobberMrns(false);
        Mockito.when((Object)this.subjectDAO.findById(1)).thenReturn((Object)this.subject1);
        Mockito.when((Object)this.subjectDAO.findById(2)).thenReturn((Object)this.subject2);
        Mockito.when((Object)this.subjectDAO.findById(3)).thenReturn((Object)this.subject3);
        Mockito.when((Object)this.subjectDAO.findById(4)).thenReturn((Object)this.subject4);
        SubjectMrn subjectMrn1 = new SubjectMrn(this.subject1, SubjectDataEncryptor.encrypt((String)"blah"), "mgh", "N");
        SubjectMrn subjectMrn2 = new SubjectMrn(this.subject2, SubjectDataEncryptor.encrypt((String)"foo"), "mgh", "N");
        SubjectMrn subjectMrn3 = new SubjectMrn(this.subject3, SubjectDataEncryptor.encrypt((String)"bar"), "mgh", "N");
        Mockito.when((Object)this.subject1.getSubjectMrnSet()).thenReturn((Object)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn1}));
        Mockito.when((Object)this.subject2.getSubjectMrnSet()).thenReturn((Object)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn2}));
        Mockito.when((Object)this.subject3.getSubjectMrnSet()).thenReturn((Object)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn3}));
    }

    @Test
    public void testMaxIndex() {
        AssertionErrors.assertEquals((String)"", (Object)4, (Object)this.importSubjectMrns.getMaxIndex());
        this.importSubjectMrns.loadIndices(4, 6, 2, 3, 1);
        AssertionErrors.assertEquals((String)"", (Object)6, (Object)this.importSubjectMrns.getMaxIndex());
    }

    @Test
    public void testSunnyPreviousPuids() throws Exception {
        Mockito.when((Object)this.subject1.getPuid()).thenReturn((Object)SubjectDataEncryptor.encrypt((String)"P1"));
        Mockito.when((Object)this.subject2.getPuid()).thenReturn((Object)SubjectDataEncryptor.encrypt((String)"P2"));
        Mockito.when((Object)this.subject3.getPuid()).thenReturn((Object)SubjectDataEncryptor.encrypt((String)"bogus"));
        CSVReader csvReader = this.getCsvReader("sunny.csv");
        this.importSubjectMrns.loopThroughCsv(csvReader);
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)1))).createEntity((BaseEntity)Mockito.any(SubjectMrn.class));
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)3))).updateEntity((BaseEntity)Mockito.any(BaseEntity.class));
    }

    @Test
    public void testSunny() throws Exception {
        CSVReader csvReader = this.getCsvReader("sunny.csv");
        this.importSubjectMrns.loopThroughCsv(csvReader);
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)1))).createEntity((BaseEntity)Mockito.any(SubjectMrn.class));
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)5))).updateEntity((BaseEntity)Mockito.any(BaseEntity.class));
    }

    @Test
    public void testRainy() throws Exception {
        CSVReader csvReader = this.getCsvReader("rainy.csv");
        SubjectMrn subjectMrn1 = new SubjectMrn(this.subject2, SubjectDataEncryptor.encrypt((String)"foo"), "mgh", "N");
        SubjectMrn subjectMrn2 = new SubjectMrn(this.subject2, SubjectDataEncryptor.encrypt((String)"bar"), "mgh", "N");
        Mockito.when((Object)this.subject2.getSubjectMrnSet()).thenReturn((Object)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn1, subjectMrn2}));
        this.importSubjectMrns.loopThroughCsv(csvReader);
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)0))).createEntity((BaseEntity)Mockito.any(SubjectMrn.class));
    }

    @Test
    public void testRainyWithClobber() throws Exception {
        CSVReader csvReader = this.getCsvReader("rainy.csv");
        SubjectMrn subjectMrn1 = new SubjectMrn(this.subject2, SubjectDataEncryptor.encrypt((String)"foo"), "mgh", "N");
        SubjectMrn subjectMrn2 = new SubjectMrn(this.subject2, SubjectDataEncryptor.encrypt((String)"bar"), "mgh", "N");
        Mockito.when((Object)this.subject2.getSubjectMrnSet()).thenReturn((Object)Sets.newHashSet((Object[])new SubjectMrn[]{subjectMrn1, subjectMrn2}));
        this.importSubjectMrns.setClobberMrns(true);
        this.importSubjectMrns.loopThroughCsv(csvReader);
        ((SubjectDAO)Mockito.verify((Object)this.subjectDAO, (VerificationMode)Mockito.times((int)0))).createEntity((BaseEntity)Mockito.any(SubjectMrn.class));
    }
}

