/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.gson.Gson;
import edu.harvard.catalyst.scheduler.dto.response.GanttEventsResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttGroupablesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourcesGroupResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourcesResponseDTO;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class GanttResponseDTO {
    public abstract String jsonify(Gson var1);

    List<TemplateResource> getRelevantTemplateResources(List<TemplateResource> allTemplateResourcesFromVisit, Predicate<? super TemplateResource> relevancePredicate) {
        List<TemplateResource> result = allTemplateResourcesFromVisit.stream().filter(relevancePredicate).collect(Collectors.toList());
        return result;
    }

    TemplateResource findTrByIdFromList(Integer id, List<TemplateResource> trList) {
        Optional<TemplateResource> trOptional = trList.stream().filter(tr -> tr.getId().equals(id)).findFirst();
        return trOptional.get();
    }

    public static enum GanttGroupingType {
        Floatables{

            @Override
            public GanttGroupablesResponseDTO create(List<TemplateResource> allTemplateResourcesFromVisit, Integer groupAspirantId) {
                return new GanttGroupablesResponseDTO(allTemplateResourcesFromVisit, TemplateResource::getUngroupedFloatable, groupAspirantId, TemplateResource::isValidFloatGroup);
            }
        }
        ,
        Flexibles{

            @Override
            public GanttGroupablesResponseDTO create(List<TemplateResource> allTemplateResourcesFromVisit, Integer groupAspirantId) {
                return new GanttGroupablesResponseDTO(allTemplateResourcesFromVisit, TemplateResource::getUngroupedFlexible, groupAspirantId, TemplateResource::isValidFlexGroup);
            }
        };


        public abstract GanttGroupablesResponseDTO create(List<TemplateResource> var1, Integer var2);
    }

    public static enum GanttInfoType {
        Resources{

            @Override
            public GanttResponseDTO create(List<TemplateResource> allTemplateResourcesFromVisit, int dayOffset, Predicate<? super TemplateResource> relevancePredicate) {
                return new GanttResourcesResponseDTO(allTemplateResourcesFromVisit, relevancePredicate);
            }
        }
        ,
        ResourcesGroup{

            @Override
            public GanttResponseDTO create(List<TemplateResource> allTemplateResourcesFromVisit, int dayOffset, Predicate<? super TemplateResource> relevancePredicate) {
                return new GanttResourcesGroupResponseDTO(allTemplateResourcesFromVisit, relevancePredicate);
            }
        }
        ,
        Events{

            @Override
            public GanttResponseDTO create(List<TemplateResource> allTemplateResourcesFromVisit, int dayOffset, Predicate<? super TemplateResource> relevancePredicate) {
                return new GanttEventsResponseDTO(allTemplateResourcesFromVisit, relevancePredicate);
            }
        };


        public abstract GanttResponseDTO create(List<TemplateResource> var1, int var2, Predicate<? super TemplateResource> var3);
    }
}

