/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LevelOfServiceReportDTO
implements CsvAbleDTO {
    private Integer visitId;
    private String studyName;
    private String visitName;
    private String nursing;
    private String nutrition;
    private String processing;
    private String setup;
    private String visitType;
    private Date checkInDate;
    private Date checkOutDate;
    private AppointmentStatusReason checkOutReason;
    private String appointmentStatus;
    private Integer duration;
    private String resourceName;

    public Integer getVisitId() {
        return this.visitId;
    }

    public void setVisitId(Integer visitId) {
        this.visitId = visitId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getNursing() {
        return this.nursing;
    }

    public void setNursing(String nursing) {
        this.nursing = nursing;
    }

    public String getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(String nutrition) {
        this.nutrition = nutrition;
    }

    public String getProcessing() {
        return this.processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }

    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = setup;
    }

    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    public Date getCheckOutDate() {
        return this.checkOutDate;
    }

    public void setCheckOutDate(Date checkOutDate) {
        this.checkOutDate = checkOutDate;
    }

    public AppointmentStatusReason getCheckOutReason() {
        return this.checkOutReason;
    }

    public void setCheckOutReason(AppointmentStatusReason checkOutReason) {
        this.checkOutReason = checkOutReason;
    }

    public String getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public void setAppointmentStatus(String appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String toCsvHeaders() {
        return "Study Name,Visit Name,Visit Type,Nursing,Nutrition,Processing,Setup,Appointment Status,Check In Date,Check Out Date,Check Out Reason";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            LevelOfServiceReportDTO d = (LevelOfServiceReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            String reason = d.checkOutReason == null ? "" : d.checkOutReason.getName();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(d.nursing));
            columns.add(MiscUtil.q(d.nutrition));
            columns.add(MiscUtil.q(d.processing));
            columns.add(MiscUtil.q(d.setup));
            columns.add(MiscUtil.q(d.appointmentStatus));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInDate)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkOutDate)));
            columns.add(MiscUtil.q(reason));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

