/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.dto.ExternalSubjectQueryBuilder;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.EpicSubjectDAO;
import edu.harvard.catalyst.scheduler.service.StandaloneSubjectService;
import edu.harvard.catalyst.scheduler.service.SubjectService;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EpicSubjectService
implements SubjectService {
    private static final Logger LOG = Logger.getLogger(EpicSubjectService.class);
    protected final EpicSubjectDAO epicSubjectDAO;
    private StandaloneSubjectService standaloneSubjectService;

    @Autowired
    public EpicSubjectService(EpicSubjectDAO epicSubjectDAO, StandaloneSubjectService standaloneSubjectService) {
        this.epicSubjectDAO = epicSubjectDAO;
        this.standaloneSubjectService = standaloneSubjectService;
    }

    EpicSubjectService() {
        this(null, null);
    }

    public EmpiSubjectDto getSubjectsAsEmpiSubjectDto(ExternalSubjectQueryBuilder externalSubjectQueryBuilder, boolean tolerateSomeTimeouts) {
        EmpiSubjectDto result = this.epicSubjectDAO.getSearchedSubjectsAsEmpiSubjectDto(externalSubjectQueryBuilder, tolerateSomeTimeouts);
        return result;
    }

    @Override
    public SubjectsResponseDTO getSearchedSubjects(String subjectLastName, String subjectFirstName, String subjectMrn, String subjectBirthDate, List<String> subjectGenderIdList) {
        String subjectGenderCode = null;
        if (subjectGenderIdList != null && subjectGenderIdList.size() == 1) {
            subjectGenderCode = subjectGenderIdList.get(0);
        }
        SubjectsResponseDTO daoResult = null;
        try {
            daoResult = this.epicSubjectDAO.getSearchedSubjects(subjectLastName, subjectFirstName, subjectMrn, subjectBirthDate, subjectGenderCode);
        }
        catch (SchedulerRuntimeException sre) {
            String code;
            String secondPart;
            boolean schedProblem;
            daoResult = this.standaloneSubjectService.getSearchedSubjects(subjectLastName, subjectFirstName, subjectMrn, subjectBirthDate, subjectGenderIdList);
            Throwable cause = sre.getCause();
            boolean sslProblem = cause != null && cause instanceof IOException;
            String firstPart = sslProblem ? "Unable to connect to external service. " : "Unable to connect to external service. ";
            boolean bl = schedProblem = daoResult.getTotalCount() == 0L;
            if (schedProblem) {
                secondPart = "At this time subject details cannot be displayed or updated, and subject cannot be added to a study. Please try again later (error XX).";
                code = sslProblem ? "60" : "41";
            } else {
                secondPart = "Data may not be fully up-to-date (error XX).";
                code = sslProblem ? "19" : "53";
            }
            String failoverMessage = MiscUtil.applyCodeToXX(firstPart + secondPart, code);
            String failoverMessageDetailed = "Subject Search. " + failoverMessage + MiscUtil.throwableInfoForLog(sre) + ". " + MiscUtil.throwableToStackTraceString(sre);
            daoResult.setEmpiFailoverMessage(failoverMessage);
            SchedulerRuntimeException.logDontThrow(failoverMessageDetailed);
        }
        return daoResult;
    }

    @Override
    public SubjectDetailResponse getSubjectData(Boolean isPuid, Integer id, String remoteHost, User user) {
        SubjectDetailResponse subjectDetailResponse = new SubjectDetailResponse();
        if (isPuid.booleanValue()) {
            try {
                subjectDetailResponse = this.epicSubjectDAO.findSubjectByUid(id);
            }
            catch (SchedulerRuntimeException sre) {
                String failoverMessage;
                Throwable cause = sre.getCause();
                boolean sslProblem = cause != null && cause instanceof IOException;
                String firstPart = sslProblem ? "Unable to connect to external service. " : "Unable to connect to external service. ";
                Object failoverMessageDetailed = "";
                try {
                    Subject subject = this.epicSubjectDAO.findInternalSubjectByPuid(String.valueOf(id));
                    SubjectDataEncryptor.decryptSubjectInPlace(subject);
                    subjectDetailResponse = new SubjectDetailResponse(subject);
                    String code = sslProblem ? "19" : "53";
                    failoverMessage = MiscUtil.applyCodeToXX(firstPart + "Data may not be fully up-to-date (error XX).", code);
                    failoverMessageDetailed = "Subject Search, Expand (+) subject info. " + failoverMessage + MiscUtil.throwableInfoForLog(sre) + MiscUtil.throwableToStackTraceString(sre);
                }
                catch (Exception e) {
                    subjectDetailResponse.setId(null);
                    String code = sslProblem ? "60" : "41";
                    failoverMessage = MiscUtil.applyCodeToXX(firstPart + "At this time subject details cannot be displayed or updated, and subject cannot be added to a study. Please try again later (error XX).", code);
                    failoverMessageDetailed = "Subject Search, Expand (+) subject info. " + failoverMessage + MiscUtil.throwableInfoForLog(sre) + MiscUtil.throwableInfoForLog(e) + ". " + MiscUtil.throwableToStackTraceString(sre) + ". " + MiscUtil.throwableToStackTraceString(e);
                }
                subjectDetailResponse.setEmpiFailoverMessage(failoverMessage);
                SchedulerRuntimeException.logDontThrow((String)failoverMessageDetailed);
            }
        } else {
            String failoverMessage;
            Object failoverMessageDetailed = "";
            try {
                Subject subject = this.epicSubjectDAO.findBySubjectId(id);
                subjectDetailResponse = new SubjectDetailResponse(subject);
                failoverMessage = MiscUtil.applyCodeToXX("Unable to connect to external service. Data may not be fully up-to-date (error XX).", "53");
                failoverMessageDetailed = "Subject Search, Expand (+) subject info. " + failoverMessage;
            }
            catch (Exception e) {
                subjectDetailResponse.setId(null);
                failoverMessage = "At this time subject details cannot be displayed or updated, and subject cannot be added to a study. Please try again later (error XX).";
                failoverMessageDetailed = "Subject Search, Expand (+) subject info. " + failoverMessage + MiscUtil.throwableInfoForLog(e) + ". " + MiscUtil.throwableToStackTraceString(e);
            }
            subjectDetailResponse.setEmpiFailoverMessage(failoverMessage);
            SchedulerRuntimeException.logDontThrow((String)failoverMessageDetailed);
        }
        return subjectDetailResponse;
    }

    @Override
    public SubjectDetailResponse findInternalSubjectByMrn(List<MrnInfoDTO> mrnInfoDTO) {
        return this.epicSubjectDAO.findInternalSubjectByMrn(mrnInfoDTO);
    }

    @Override
    public SubjectDetailResponse getExternalSubjectDataUsingMrn(MrnInfoDTO mrnInfoDTO) {
        if (mrnInfoDTO != null) {
            SubjectDetailResponse subjectDetailResponse = null;
            try {
                subjectDetailResponse = this.epicSubjectDAO.getSubjectDetailsUsingMrnAndSite(mrnInfoDTO.getValue(), mrnInfoDTO.getInstitution());
            }
            catch (SchedulerRuntimeException sre) {
                String code;
                String secondPart;
                Throwable cause = sre.getCause();
                boolean sslProblem = cause != null && cause instanceof IOException;
                String firstPart = sslProblem ? "Unable to connect to external service. " : "Unable to connect to external service. ";
                subjectDetailResponse = this.standaloneSubjectService.findInternalSubjectByMrn(Lists.newArrayList((Object[])new MrnInfoDTO[]{mrnInfoDTO}));
                if (subjectDetailResponse.getId() != null) {
                    secondPart = "Data may not be fully up-to-date (error XX).";
                    code = sslProblem ? "19" : "53";
                } else {
                    secondPart = "At this time subject details cannot be displayed or updated, and subject cannot be added to a study. Please try again later (error XX).";
                    code = sslProblem ? "60" : "41";
                }
                String failoverMessage = MiscUtil.applyCodeToXX(firstPart + secondPart, code);
                String failoverMessageDetailed = "Study Subject, View Details. " + failoverMessage + MiscUtil.throwableInfoForLog(sre) + ". " + MiscUtil.throwableToStackTraceString(sre);
                subjectDetailResponse.setEmpiFailoverMessage(failoverMessage);
                SchedulerRuntimeException.logDontThrow(failoverMessageDetailed);
            }
            return subjectDetailResponse;
        }
        return new SubjectDetailResponse();
    }

    public Ethnicity lookupEmpiEthnicityString(String ethnicity) {
        return this.epicSubjectDAO.lookupEmpiEthnicityString(ethnicity);
    }
}

