/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.Collections;
import java.util.List;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.X509CRL;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IndexingObjectStore;
import org.opensaml.xml.validation.AbstractValidatingXMLObject;

public class X509CRLImpl
extends AbstractValidatingXMLObject
implements X509CRL {
    private static final IndexingObjectStore<String> B64_CRL_STORE = new IndexingObjectStore();
    private String b64CRLIndex;

    protected X509CRLImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public String getValue() {
        return B64_CRL_STORE.get(this.b64CRLIndex);
    }

    @Override
    public void setValue(String newValue) {
        String b64Cert;
        String currentCert = B64_CRL_STORE.get(this.b64CRLIndex);
        if (!DatatypeHelper.safeEquals(currentCert, b64Cert = this.prepareForAssignment(currentCert, newValue))) {
            B64_CRL_STORE.remove(this.b64CRLIndex);
            this.b64CRLIndex = B64_CRL_STORE.put(b64Cert);
        }
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        B64_CRL_STORE.remove(this.b64CRLIndex);
    }
}

