/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.binding.decoding.BaseSAML2MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;

public class HTTPArtifactDecoderImpl
extends BaseSAML2MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoderImpl.class);
    private ArtifactResolutionProfile resolutionProfile;

    public HTTPArtifactDecoderImpl(ArtifactResolutionProfile resolutionProfile, ParserPool parserPool) {
        super(parserPool);
        this.resolutionProfile = resolutionProfile;
    }

    protected boolean isIntendedDestinationEndpointURIRequired(org.opensaml.common.binding.SAMLMessageContext samlMsgCtx) {
        return false;
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof org.opensaml.common.binding.SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        SAMLMessageContext samlMessageContext = (SAMLMessageContext)messageContext;
        if (!(samlMessageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        HTTPInTransport inTransport = (HTTPInTransport)samlMessageContext.getInboundMessageTransport();
        HTTPOutTransport outTransport = (HTTPOutTransport)samlMessageContext.getOutboundMessageTransport();
        String artifactId = DatatypeHelper.safeTrimOrNullString((String)inTransport.getParameterValue("SAMLart"));
        if (artifactId == null) {
            this.log.error("SAMLart parameter was missing or did not contain a value.");
            throw new MessageDecodingException("SAMLArt parameter was missing or did not contain a value.");
        }
        this.log.debug("Artifact id: {}", (Object)artifactId);
        samlMessageContext.setRelayState(inTransport.getParameterValue("RelayState"));
        this.log.debug("Decoded RelayState: {}", (Object)samlMessageContext.getRelayState());
        SAMLObject message = this.resolutionProfile.resolveArtifact(samlMessageContext, artifactId, this.getActualReceiverEndpointURI((org.opensaml.common.binding.SAMLMessageContext)samlMessageContext));
        samlMessageContext.setInboundSAMLMessage(message);
        samlMessageContext.setInboundMessageTransport((InTransport)inTransport);
        samlMessageContext.setOutboundMessageTransport((OutTransport)outTransport);
        samlMessageContext.setInboundSAMLBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        this.populateMessageContext((org.opensaml.common.binding.SAMLMessageContext)samlMessageContext);
    }
}

