/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.gson.Gson;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import java.util.List;
import java.util.function.Predicate;

public final class GanttResourcesResponseDTO
extends GanttResponseDTO {
    private final List<GanttResourceDetail> ganttResourceDetailList;
    private final int totalVisitResources;
    private final int totalVisitCalendarDays;

    public List<GanttResourceDetail> getGanttResourceDetailList() {
        return this.ganttResourceDetailList;
    }

    public GanttResourcesResponseDTO(List<TemplateResource> allTemplateResourcesFromVisit, Predicate<? super TemplateResource> relevancePredicate) {
        List<TemplateResource> relevantTemplateResourcesFromVisit = this.getRelevantTemplateResources(allTemplateResourcesFromVisit, relevancePredicate);
        this.ganttResourceDetailList = RichList.enrich(relevantTemplateResourcesFromVisit).map(tr -> new GanttResourceDetail((TemplateResource)tr)).toList();
        this.totalVisitResources = allTemplateResourcesFromVisit.size();
        this.totalVisitCalendarDays = TemplateResource.totalVisitCalendarDays(allTemplateResourcesFromVisit);
    }

    @Override
    public String jsonify(Gson gson) {
        return gson.toJson((Object)this);
    }

    public static final class GanttResourceDetail {
        private final String resourceName;
        private final String resourceType;
        private final int id;
        private final int templateResourceId;

        GanttResourceDetail(TemplateResource templateResource) {
            if (templateResource == null || templateResource.getResource() == null) {
                SchedulerRuntimeException.logAndThrow("TemplateResource and Resource should be non-null");
            }
            this.templateResourceId = templateResource.getId();
            Resource itsResource = templateResource.getResource();
            boolean isGrouped = templateResource.getGroupId() != null;
            this.id = isGrouped ? this.templateResourceId : itsResource.getId();
            this.resourceName = itsResource.getName();
            this.resourceType = itsResource.getResourceType().getName();
        }
    }
}

