/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.RichIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RichList<A>
implements Iterable<A> {
    protected final List<A> delegate;
    private static final RichList<?> Empty = RichList.enrich(Collections.emptyList());

    RichList(Stream<A> delegate) {
        this(RichList.toList(delegate));
    }

    public RichList(List<A> delegate) {
        this.delegate = delegate;
    }

    public static final <A> RichList<A> empty() {
        return Empty;
    }

    public static <A> RichList<A> enrich(List<A> list) {
        return new RichList<A>(list);
    }

    public static final <A> RichList<A> newRichList() {
        return RichList.enrich(Lists.newArrayList());
    }

    private static final <A> List<A> toList(Stream<A> stream) {
        return stream.collect(Collectors.toList());
    }

    @Override
    public final Iterator<A> iterator() {
        return this.delegate.iterator();
    }

    public final RichList<A> append(Iterable<? extends A> as) {
        ArrayList<A> newDelegate = new ArrayList<A>(this.delegate);
        as.forEach(newDelegate::add);
        return new RichList<A>(newDelegate);
    }

    public final RichIterator<A> richIterator() {
        return RichIterator.enrich(this.delegate.iterator());
    }

    final Stream<A> toStream() {
        return this.delegate.stream();
    }

    public final List<A> toList() {
        return this.delegate;
    }

    public final Set<A> toSet() {
        return Sets.newHashSet(this.delegate);
    }

    public final int size() {
        return this.delegate.size();
    }

    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public final boolean contains(A a) {
        return this.delegate.contains(a);
    }

    public final A get(int index) {
        return this.delegate.get(index);
    }

    private static final <A> List<A> copyOf(List<A> l) {
        return Lists.newArrayList(l);
    }

    public final RichList<A> prepend(A element) {
        return this.modifyEnd(element, (list, a) -> list.add(0, a));
    }

    public final RichList<A> append(A element) {
        return this.modifyEnd(element, (list, a) -> list.add(a));
    }

    private RichList<A> modifyEnd(A a, BiConsumer<List<A>, A> adder) {
        List<A> defensiveCopy = RichList.copyOf(this.delegate);
        adder.accept(defensiveCopy, a);
        return RichList.enrich(defensiveCopy);
    }

    public final Optional<A> findFirst() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.delegate.get(0));
    }

    @Override
    public final void forEach(Consumer<? super A> f) {
        this.delegate.forEach(f);
    }

    public final <B> RichList<B> map(Function<? super A, ? extends B> f) {
        return new RichList<B>(this.toStream().map(f));
    }

    public final <B> RichList<B> flatMap(Function<? super A, ? extends RichList<B>> f) {
        return new RichList(this.toStream().flatMap((? super T a) -> ((RichList)f.apply((Object)a)).toStream()));
    }

    public final <B> RichList<B> flatMapList(Function<? super A, ? extends List<B>> f) {
        return new RichList(this.toStream().flatMap((? super T a) -> ((List)f.apply((Object)a)).stream()));
    }

    public final <B> RichList<B> flatMapOptional(Function<? super A, Optional<B>> f) {
        List optionals = this.map(f).toList();
        return new RichList(ListUtils.flatten(optionals));
    }

    public final RichList<A> filter(Predicate<? super A> p) {
        return new RichList<A>(this.toStream().filter(p));
    }

    public final Pair<RichList<A>, RichList<A>> partition(Predicate<? super A> p) {
        return Pair.pair(this.filter(p), this.filter(p.negate()));
    }

    public final Pair<List<A>, List<A>> partitionToList(Predicate<? super A> p) {
        return this.partition(p).transform(RichList::toList, RichList::toList);
    }

    public final Optional<A> find(Predicate<? super A> p) {
        return this.toStream().filter(p).findFirst();
    }

    public final boolean exists(Predicate<? super A> p) {
        return this.toStream().anyMatch(p);
    }

    public final RichList<A> limit(int howMany) {
        if (howMany >= this.size()) {
            return this;
        }
        return new RichList<A>(this.toStream().limit(howMany));
    }

    public final RichList<A> skip(int howMany) {
        if (this.isEmpty() || howMany < 1) {
            return this;
        }
        if (howMany >= this.size()) {
            return RichList.empty();
        }
        return new RichList<A>(Lists.newArrayList(this.delegate.subList(howMany, this.size())));
    }

    public final RichList<A> skipRight(int howMany) {
        if (this.isEmpty() || howMany > this.size()) {
            return RichList.empty();
        }
        if (howMany >= this.size()) {
            return RichList.empty();
        }
        return new RichList<A>(Lists.newArrayList(this.delegate.subList(0, this.size() - howMany)));
    }

    public final RichList<A> distinct() {
        return new RichList<A>(this.toStream().distinct());
    }

    public final Optional<A> reduce(BinaryOperator<A> combiner) {
        return this.delegate.stream().reduce(combiner);
    }

    public final <B> B fold(B zero, BiFunction<? super B, ? super A, ? extends B> aggregate) {
        B accumulator = zero;
        for (A a : this.toList()) {
            accumulator = aggregate.apply(accumulator, a);
        }
        return accumulator;
    }

    public final Optional<A> min(Comparator<? super A> ordering) {
        return this.delegate.stream().min(ordering);
    }

    public final Optional<A> max(Comparator<? super A> ordering) {
        return this.delegate.stream().max(ordering);
    }

    public final RichList<A> sortWith(Comparator<? super A> ordering) {
        return new RichList<A>(this.delegate.stream().sorted(ordering));
    }

    public final <F extends Comparable<F>> RichList<A> sortBy(Function<A, F> getField) {
        Comparator ordering = (a1, a2) -> {
            Comparable field1 = (Comparable)getField.apply(a1);
            Comparable field2 = (Comparable)getField.apply(a2);
            return field1.compareTo(field2);
        };
        return this.sortWith(ordering);
    }

    public final <B> RichList<Pair<A, B>> zip(List<B> rhs) {
        return this.zip(RichList.enrich(rhs));
    }

    public final <B> RichList<Pair<A, B>> zip(RichList<B> rhs) {
        int resultSize = Math.min(this.size(), rhs.size());
        ArrayList<Pair<A, B>> result = new ArrayList<Pair<A, B>>(resultSize);
        Iterator<A> as = this.iterator();
        Iterator<B> bs = rhs.iterator();
        while (as.hasNext() && bs.hasNext()) {
            result.add(Pair.pair(as.next(), bs.next()));
        }
        return RichList.enrich(result);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RichList other = (RichList)obj;
        return !(this.delegate == null ? other.delegate != null : !this.toList().equals(other.toList()));
    }

    public String toString() {
        return "RichList [" + this.toList() + "]";
    }
}

