/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.subjectDataCleaner;

import com.opencsv.CSVReader;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.StandaloneSubjectService;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.security.Key;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
class SubjectDataMerger {
    public static final String MERGED_BY_SUBJECT_DATA_CLEAN_UP_PROGRAM_SUBJECT_DATA_MERGER = "Merged by subject data clean-up program (SubjectDataMerger)";
    protected final SubjectDAO subjectDAO;
    protected final StudyDAO studyDAO;
    protected final AppointmentDAO appointmentDao;
    protected final StandaloneSubjectService standaloneSubjectService;
    @Option(name="-help", required=false, usage="outputs usage info")
    boolean help = false;
    @Option(name="-noDecrypt", required=false, usage="do not decrypt subjects")
    boolean noDecrypt = false;
    @Argument(index=0, required=true, usage="the input file, containing comma-separated pairs of MRNs (with NO spaces)")
    String inputFileName;
    final Date today;
    final String todayString;
    final long todayMilliseconds;
    boolean decrypt = true;
    static final Logger log = Logger.getLogger(SubjectDataMerger.class);

    public static void main(String[] args) {
        LogManager.getRootLogger().setLevel(Level.ERROR);
        LogManager.getLogger(SubjectDataMerger.class).setLevel(Level.INFO);
        try {
            Date startDate = new Date();
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-subject-data-cleaner.xml");
            SubjectDataMerger subjectDataCleaner = (SubjectDataMerger)context.getBean("subjectDataMerger");
            subjectDataCleaner.setUp(args);
            subjectDataCleaner.readCsvAndMergeSubjects();
            Date endDate = new Date();
            long elapsed = endDate.getTime() - startDate.getTime();
            log.info((Object)("Executed in " + elapsed / 1000L + " seconds"));
        }
        catch (Exception e) {
            log.error((Object)"The following exception/error was thrown:\n", (Throwable)e);
        }
    }

    @Autowired
    SubjectDataMerger(@Qualifier(value="encryptionKeyForSubjectDataCleanUp") Key key, SubjectDAO subjectDAO, StudyDAO studyDAO, AppointmentDAO appointmentDao, StandaloneSubjectService standaloneSubjectService) {
        this.subjectDAO = subjectDAO;
        this.studyDAO = studyDAO;
        this.appointmentDao = appointmentDao;
        this.standaloneSubjectService = standaloneSubjectService;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
        this.today = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        this.todayString = dateFormat.format(this.today);
        this.todayMilliseconds = this.today.getTime();
    }

    private void setUp(String[] args) throws IOException {
        this.parseCommandLineAndExitIfNeeded(args);
        log.info((Object)("Running Subject Data Merger on " + this.todayString + " with the following input parameters:"));
        log.info((Object)("decrypt: " + this.decrypt));
        log.info((Object)("input file: " + this.inputFileName));
    }

    void parseCommandLineAndExitIfNeeded(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            if (this.help) {
                this.printUsageAndExampleCommandLine(parser);
                System.exit(0);
            }
        }
        catch (CmdLineException e) {
            log.error((Object)e.getMessage());
            this.printUsageAndExampleCommandLine(parser);
            System.exit(-1);
        }
        this.decrypt = !this.noDecrypt;
    }

    void printUsageAndExampleCommandLine(CmdLineParser parser) {
        System.err.println("Usage:");
        System.err.println("  java " + this.getClass().getName() + " [options...]");
        System.err.println("where the options are:");
        parser.printUsage((OutputStream)System.err);
        System.err.println("  Example: java " + this.getClass().getName() + " " + parser.printExample(ExampleMode.ALL));
    }

    void readCsvAndMergeSubjects() throws SQLException, IOException {
        try (FileReader fileReader = new FileReader(this.inputFileName);
             CSVReader csvReader = new CSVReader((Reader)fileReader);){
            CharSequence[] nextLine;
            int rowNumber = 0;
            while ((nextLine = csvReader.readNext()) != null) {
                ++rowNumber;
                if (nextLine.length != 2) {
                    log.error((Object)("CSV input row number " + rowNumber + " has " + nextLine.length + " values instead of 2: " + String.join((CharSequence)", ", nextLine)));
                    continue;
                }
                int secondaryId = Integer.parseInt(nextLine[0].trim());
                int primaryId = Integer.parseInt(nextLine[1].trim());
                if (primaryId == secondaryId) {
                    log.error((Object)("At CSV input row number " + rowNumber + ": Cannot merge a subject into itself, ID = " + secondaryId));
                    continue;
                }
                this.mergeSubject(secondaryId, primaryId, rowNumber);
            }
        }
        log.info((Object)"");
    }

    String decryptIfNeeded(String str) {
        return this.decrypt ? SubjectDataEncryptor.decrypt((String)str) : str;
    }

    public void mergeSubject(int secondarySubjectId, int primarySubjectId, int rowNumber) {
        Subject primarySubject = this.subjectDAO.findById(primarySubjectId);
        if (null == primarySubject) {
            log.error((Object)("  At line " + rowNumber + " the following subject ID has no match (it may have been previously deleted): " + primarySubjectId));
            return;
        }
        Subject secondarySubject = this.subjectDAO.findById(secondarySubjectId);
        if (null == secondarySubject) {
            log.error((Object)("  At line " + rowNumber + " the following subject ID has no match (it may have been previously deleted): " + secondarySubjectId));
            return;
        }
        Set primaryMrns = primarySubject.getSubjectMrnSet();
        if (primaryMrns.size() == 0) {
            log.error((Object)("At line " + rowNumber + " primary subject with ID " + primarySubjectId + " does not have an MRN. It will be ignored."));
            return;
        }
        if (primaryMrns.size() != 1) {
            log.error((Object)("At line " + rowNumber + " primary subject with ID " + primarySubjectId + " has more than one MRN. It will be ignored."));
            return;
        }
        SubjectMrn primarySubjectMrn = (SubjectMrn)primaryMrns.iterator().next();
        String primaryMrnString = primarySubjectMrn.getMrn();
        Set secondaryMrns = secondarySubject.getSubjectMrnSet();
        if (secondaryMrns.size() == 0) {
            log.error((Object)("At line " + rowNumber + " secondary subject with ID " + secondarySubjectId + " does not have an MRN. It will be ignored."));
            return;
        }
        if (secondaryMrns.size() != 1) {
            log.error((Object)("At line " + rowNumber + " secondary subject with ID " + secondarySubjectId + " has more than one MRN. It will be ignored."));
            return;
        }
        SubjectMrn secondarySubjectMrn = (SubjectMrn)secondaryMrns.iterator().next();
        String secondaryMrnString = secondarySubjectMrn.getMrn();
        String searchPrimaryMrnString = primaryMrnString;
        String searchSecondaryMrnString = secondaryMrnString;
        if (this.decrypt) {
            primaryMrnString = SubjectDataEncryptor.decrypt((String)primaryMrnString);
            secondaryMrnString = SubjectDataEncryptor.decrypt((String)secondaryMrnString);
        }
        String primarySubjectDescription = "subject with ID " + primarySubjectId + " and MRN " + primaryMrnString;
        String secondarySubjectDescription = "subject with ID " + secondarySubjectId + " and MRN " + secondaryMrnString;
        log.info((Object)("Merging " + secondarySubjectDescription + " into " + primarySubjectDescription));
        List primaryStudySubjects = this.studyDAO.findStudySubjectBySubjectMrn(primarySubjectMrn);
        Map primaryStudySubjectsMap = primaryStudySubjects.stream().collect(Collectors.toMap(ss -> ss.getStudy().getId(), Function.identity()));
        Set<Integer> primaryStudyIds = primaryStudySubjectsMap.keySet();
        List secondaryStudySubjects = this.studyDAO.findStudySubjectBySubjectMrn(secondarySubjectMrn);
        ArrayList<String> changeDetails = new ArrayList<String>();
        changeDetails.add(secondarySubjectDescription + " merged into " + primarySubjectDescription);
        secondaryStudySubjects.stream().forEach(secondaryStudySubject -> {
            Study secondaryStudy = secondaryStudySubject.getStudy();
            Integer secondaryStudyId = secondaryStudy.getId();
            List bookedVisits = this.appointmentDao.getAllBookedVisitByStudyAndSubjectMrn(secondaryStudy, secondarySubjectMrn);
            this.remapBookedVisits(bookedVisits, primarySubjectMrn, changeDetails);
            if (primaryStudyIds.contains(secondaryStudyId)) {
                log.info((Object)("  Removing subject_study record for study '" + secondaryStudySubject.getStudy().getName() + "' and secondary subject '" + this.decryptIfNeeded(secondaryStudySubject.getSubjectMrn().getMrn()) + "' because that study is already associated with the primary subject '" + this.decryptIfNeeded(primarySubjectMrn.getMrn()) + "'"));
                changeDetails.add("StudySubject#" + secondaryStudySubject.getId() + ":DELETED");
                this.studyDAO.deleteEntity((BaseEntity)secondaryStudySubject);
            } else {
                log.info((Object)("  Remap subject_study record for study '" + secondaryStudySubject.getStudy().getName() + "' and secondary subject " + this.decryptIfNeeded(secondaryStudySubject.getSubjectMrn().getMrn()) + "' to point to primary subject " + this.decryptIfNeeded(primarySubjectMrn.getMrn()) + "'"));
                changeDetails.add("StudySubject#" + secondaryStudySubject.getId() + ".subject:from#" + secondaryStudySubject.getSubject().getId() + ":to#" + primarySubject.getId());
                secondaryStudySubject.setSubjectMrn(primarySubjectMrn);
                this.studyDAO.updateEntity((BaseEntity)secondaryStudySubject);
            }
        });
        log.info((Object)("  Archived (MERGED) subject " + secondaryMrnString));
        this.standaloneSubjectService.markAsMerged(secondarySubject, MERGED_BY_SUBJECT_DATA_CLEAN_UP_PROGRAM_SUBJECT_DATA_MERGER, String.join((CharSequence)",", changeDetails));
    }

    public void remapBookedVisits(List<BookedVisit> bookedVisits, SubjectMrn primarySubjectMrn, List<String> changeDetails) {
        bookedVisits.stream().forEach(bookedVisit -> {
            changeDetails.add("BookedVisit#" + bookedVisit.getId() + ".subjectMrn:from#" + bookedVisit.getSubjectMrn().getMrn() + ":to#" + primarySubjectMrn.getMrn());
            bookedVisit.setSubjectMrn(primarySubjectMrn);
            this.appointmentDao.updateEntity((BaseEntity)bookedVisit);
        });
    }

    class MrnFoundMultipleTimesException
    extends RuntimeException {
        int numberOfMatches;

        MrnFoundMultipleTimesException(int numberOfMatches) {
            this.numberOfMatches = numberOfMatches;
        }
    }

    class MrnNotFoundException
    extends RuntimeException {
        MrnNotFoundException() {
        }
    }
}

