/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.HasReportFiltersNameAndId;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.RoleType;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.FieldProcessingEnum;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;

@Entity
@Table(name="field")
public class Field
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String table;
    private String column;
    private String displayName;
    private boolean sortable;
    private FieldType fieldType;
    private FieldProcessingEnum fieldProcessingEnum;
    private static Map<String, String> fkFieldToTable = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"cancel_status", (Object)"cancellation_status")});
    private static Map<String, String> userSuffixToJoinColumn = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"_inv", (Object)"principal_investigator"), Pair.pair((Object)"_sch", (Object)"primary_scheduling_contact"), Pair.pair((Object)"_nrs", (Object)"protocol_nurse"), Pair.pair((Object)"_nut", (Object)"protocol_nutritionist"), Pair.pair((Object)"_doc", (Object)"responsible_physician"), Pair.pair((Object)"_doc2", (Object)"responsible_physician2"), Pair.pair((Object)"_sch2", (Object)"secondary_scheduling_contact"), Pair.pair((Object)"_sch3", (Object)"scheduler3"), Pair.pair((Object)"_nrs2", (Object)"associate_nurse"), Pair.pair((Object)"_nut2", (Object)"associate_protocol_nutritionist")});
    private static Map<String, String> tableAlias = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"booked_visit", (Object)"bv"), Pair.pair((Object)"visit_template", (Object)"vt"), Pair.pair((Object)"subject", (Object)"j"), Pair.pair((Object)"booked_resource", (Object)"br"), Pair.pair((Object)"template_resource", (Object)"tr"), Pair.pair((Object)"override_booked_resource_annotations", (Object)"bra"), Pair.pair((Object)"template_resource_annotations", (Object)"tra"), Pair.pair((Object)"line_level_annotations", (Object)"lla"), Pair.pair((Object)"study", (Object)"s"), Pair.pair((Object)"user", (Object)"u"), Pair.pair((Object)"study_funding_source_cai", (Object)"sfs"), Pair.pair((Object)"subject_mrn", (Object)"sm"), Pair.pair((Object)"resource_type", (Object)"rsrc_type"), Pair.pair((Object)"resource", (Object)"rsrc")});

    public String commaJoinedStringToSqlString(String shortName, String commaString) {
        return this.fieldType.commaJoinedStringToSqlString(this, shortName, commaString);
    }

    private static Map<Integer, HasReportFiltersNameAndId> enumArrayToMapIntegerToHasEtc(Enum[] enumArray) {
        List hasReportFiltersNameAndIdList = Lists.newArrayList((Object[])enumArray).stream().map(e -> (HasReportFiltersNameAndId)((Object)e)).collect(Collectors.toList());
        Map<Integer, HasReportFiltersNameAndId> result = hasReportFiltersNameAndIdList.stream().collect(Collectors.toMap(HasReportFiltersNameAndId::getReportFiltersId, Function.identity()));
        return result;
    }

    public static String getFkFieldToTable(String fkColumn) {
        String lookup = fkFieldToTable.get(fkColumn);
        return lookup != null ? lookup : fkColumn;
    }

    public static Map<String, String> getUserSuffixToJoinColumn() {
        return userSuffixToJoinColumn;
    }

    public Field() {
        this(null, null, null, null);
    }

    public Field(Integer id, String table, String column, String displayName) {
        super(id);
        this.table = table;
        this.column = column;
        this.displayName = displayName;
        this.fieldProcessingEnum = FieldProcessingEnum.DEFAULT;
    }

    public static String getTableAlias(String table) {
        return tableAlias.get(table);
    }

    @Column(name="processing")
    @Enumerated(value=EnumType.STRING)
    @Basic(optional=true)
    public FieldProcessingEnum getFieldProcessingEnum() {
        return this.fieldProcessingEnum;
    }

    public void setFieldProcessingEnum(FieldProcessingEnum fieldProcessingEnum) {
        this.fieldProcessingEnum = fieldProcessingEnum;
    }

    @Column(name="table_name")
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Column(name="name")
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Column(name="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Column(name="sortable")
    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public static enum FieldType {
        Number{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.betweenHelper(shortName, commaString, "'", "'");
            }
        }
        ,
        Date{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.dateHelper(shortName, commaString);
            }
        }
        ,
        LongSetString{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.longStringHelper(shortName, commaString);
            }
        }
        ,
        ShortString{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.shortStringHelper(shortName, commaString);
            }
        }
        ,
        ShortSetStringUI{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.innyHelper(shortName, commaString, "'");
            }
        }
        ,
        Boolean{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.booleanHelper(shortName, commaString);
            }
        }
        ,
        ShortSetStringDbLongName{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.innyHelper(shortName, commaString, "'");
            }
        }
        ,
        ShortSetStringDbShortName{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.innyHelper(shortName, commaString, "'");
            }
        }
        ,
        ShortSetStringDbIdBack{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                String nameToId = shortName.replaceAll("\\.name$", ".id");
                return FieldType.innyHelper(nameToId, commaString, "");
            }
        }
        ,
        ShortSetStringDB{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.innyHelper(shortName, commaString, "'");
            }
        }
        ,
        Enum{

            @Override
            public String commaJoinedStringToSqlString(Field myField, String shortName, String commaString) {
                return FieldType.enumInnyHelper(myField, shortName, commaString, "'");
            }
        };

        private static Map<String, Map<String, Map<Integer, HasReportFiltersNameAndId>>> mapTableToColumnToIntegerToHasEtc;

        public abstract String commaJoinedStringToSqlString(Field var1, String var2, String var3);

        public static String quotifyCommaString(String commaString, String openQuote, String closeQuote, String joinString) {
            ArrayList stringList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString));
            List quotedStringList = stringList.stream().map(s -> openQuote + s + closeQuote).collect(Collectors.toList());
            String result = Joiner.on((String)joinString).join(quotedStringList);
            return result;
        }

        private static String dateHelper(String shortName, String commaString) {
            ArrayList dateList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString));
            List sqlDateList = dateList.stream().map(s -> s.replaceAll(" +(\\d+:\\d+:\\d+).*", " $1")).map(s -> DateUtility.parse(DateUtility.dateMonthDayYear(), s)).map(d -> DateUtility.format(DateUtility.dateHourMinSec(), d)).collect(Collectors.toList());
            String sqlCommaString = Joiner.on((String)",").join(sqlDateList);
            return FieldType.betweenHelper(shortName, sqlCommaString, "timestamp('", "')");
        }

        private static String booleanHelper(String shortName, String commaString) {
            ArrayList commaStringValues = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString));
            ArrayList orSubClauses = Lists.newArrayList();
            FieldType.possiblyMoveNullFromValuesToSubClauses(commaStringValues, orSubClauses, shortName, "");
            if (!commaStringValues.isEmpty()) {
                List translatedValues = commaStringValues.stream().map(o -> o.replaceAll("Yes", "true")).map(o -> o.replaceAll("No", "false")).collect(Collectors.toList());
                String translatedCommaString = Joiner.on((String)",").join(translatedValues);
                orSubClauses.add(FieldType.innyHelper(shortName, translatedCommaString, ""));
            }
            StringBuilder builder = new StringBuilder().append("(").append(Joiner.on((String)" OR ").join((Iterable)orSubClauses)).append(")");
            String result = builder.toString();
            return result;
        }

        private static void possiblyMoveNullFromValuesToSubClauses(List<String> values, List<String> clauses, String shortName, String orEmpty) {
            if (values.contains("Null")) {
                values.remove("Null");
                clauses.add("(" + shortName + " is NULL" + orEmpty + ")");
            }
        }

        private static String shortStringHelper(String shortName, String commaString) {
            ArrayList commaStringValues = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString));
            ArrayList orSubClauses = Lists.newArrayList();
            FieldType.possiblyMoveNullFromValuesToSubClauses(commaStringValues, orSubClauses, shortName, " or " + shortName + " = ''");
            if (!commaStringValues.isEmpty()) {
                String nonNullsCommaString = Joiner.on((String)",").join((Iterable)commaStringValues);
                orSubClauses.add(FieldType.innyHelper(shortName, nonNullsCommaString, "'"));
            }
            StringBuilder builder = new StringBuilder().append("(").append(Joiner.on((String)" OR ").join((Iterable)orSubClauses)).append(")");
            String result = builder.toString();
            return result;
        }

        private static String innyHelper(String shortName, String commaString, String quote) {
            String innyExpression = FieldType.quotifyCommaString(commaString, quote, quote, ",");
            StringBuilder builder = new StringBuilder().append("(").append(shortName).append(" IN (").append(innyExpression).append("))");
            return builder.toString();
        }

        private static String enumInnyHelper(Field myField, String shortName, String commaString, String quote) {
            List enumValues = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString)).stream().map(o -> FieldType.getEnumValue(myField, Integer.valueOf(o))).collect(Collectors.toList());
            String substitutedCommaString = Joiner.on((String)",").join(enumValues);
            return FieldType.innyHelper(shortName, substitutedCommaString, quote);
        }

        private static String betweenHelper(String shortName, String commaString, String openQuote, String closeQuote) {
            String betweenAndExpression = FieldType.quotifyCommaString(commaString, openQuote, closeQuote, " AND ");
            StringBuilder builder = new StringBuilder().append("(").append(shortName).append(" BETWEEN ").append(betweenAndExpression).append(")");
            return builder.toString();
        }

        private static String longStringHelper(String shortName, String commaString) {
            String emptyPhrase2;
            String emptyPhraseConnector;
            String nonOrNull;
            ArrayList components = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)commaString));
            if (components.size() == 2) {
                return "true";
            }
            if (((String)components.get(0)).trim().equalsIgnoreCase("includes")) {
                nonOrNull = " NOT NULL";
                emptyPhraseConnector = " AND";
                emptyPhrase2 = " != ''";
            } else {
                nonOrNull = " NULL";
                emptyPhraseConnector = " OR";
                emptyPhrase2 = " = ''";
            }
            StringBuilder builder = new StringBuilder().append("(").append(shortName).append(" IS").append(nonOrNull).append(emptyPhraseConnector).append(" ").append(shortName).append(emptyPhrase2).append(")");
            return builder.toString();
        }

        public static List<HasReportFiltersNameAndId> getFieldTypeEnums(Field enumTypeField) {
            String table = enumTypeField.getTable();
            String column = enumTypeField.getColumn();
            Map<Integer, HasReportFiltersNameAndId> hasEtcMap = mapTableToColumnToIntegerToHasEtc.get(table).get(column);
            return Lists.newArrayList(hasEtcMap.values());
        }

        public static String getEnumValue(Field enumTypeField, int ordinal) {
            String table = enumTypeField.getTable();
            String column = enumTypeField.getColumn();
            String result = mapTableToColumnToIntegerToHasEtc.get(table).get(column).get(ordinal).name();
            return result;
        }

        static {
            mapTableToColumnToIntegerToHasEtc = Maps.newHashMap();
            HashMap userToHasEtcList = Maps.newHashMap();
            HashMap visitTemplateToHasEtcList = Maps.newHashMap();
            HashMap bookedVisitToHasEtcList = Maps.newHashMap();
            HashMap resourceToHasEtcList = Maps.newHashMap();
            userToHasEtcList.put("institution_role", Field.enumArrayToMapIntegerToHasEtc(InstitutionRoleType.values()));
            userToHasEtcList.put("role", Field.enumArrayToMapIntegerToHasEtc(RoleType.values()));
            resourceToHasEtcList.put("type", Field.enumArrayToMapIntegerToHasEtc(ResourceType.values()));
            mapTableToColumnToIntegerToHasEtc.put("user", userToHasEtcList);
            mapTableToColumnToIntegerToHasEtc.put("visit_template", visitTemplateToHasEtcList);
            mapTableToColumnToIntegerToHasEtc.put("booked_visit", bookedVisitToHasEtcList);
            mapTableToColumnToIntegerToHasEtc.put("resource", resourceToHasEtcList);
        }
    }

    public static class HasReportFiltersNameAndIdPair {
        private int id;
        private String name;

        public HasReportFiltersNameAndIdPair(HasReportFiltersNameAndId theEnum) {
            this.id = theEnum.getReportFiltersId();
            this.name = theEnum.getReportFiltersName();
        }
    }
}

