/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.SAMLStatusException;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.Assert;

public class SAMLLogoutProcessingFilter
extends LogoutFilter {
    protected SAMLProcessor processor;
    protected SingleLogoutProfile logoutProfile;
    protected SAMLLogger samlLogger;
    protected SAMLContextProvider contextProvider;
    protected static final Logger log = LoggerFactory.getLogger(SAMLLogoutProcessingFilter.class);
    public static final String FILTER_URL = "/saml/SingleLogout";
    private final List<LogoutHandler> handlers;

    public SAMLLogoutProcessingFilter(String logoutSuccessUrl, LogoutHandler ... handlers) {
        super(logoutSuccessUrl, handlers);
        this.setFilterProcessesUrl(FILTER_URL);
        this.handlers = Arrays.asList(handlers);
    }

    public SAMLLogoutProcessingFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler ... handlers) {
        super(logoutSuccessHandler, handlers);
        this.handlers = Arrays.asList(handlers);
        this.setFilterProcessesUrl(FILTER_URL);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.processLogout((HttpServletRequest)req, (HttpServletResponse)res, chain);
    }

    public void processLogout(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresLogout(request, response)) {
            SAMLMessageContext context;
            try {
                log.debug("Processing SAML logout message");
                context = this.contextProvider.getLocalEntity(request, response);
                context.setCommunicationProfileId(this.getProfileName());
                this.processor.retrieveMessage(context);
                context.setLocalEntityEndpoint((Endpoint)SAMLUtil.getEndpoint(context.getLocalEntityRoleMetadata().getEndpoints(), context.getInboundSAMLBinding(), this.getFilterProcessesUrl()));
            }
            catch (SAMLException e) {
                this.logger.debug((Object)"Incoming SAML message is invalid", (Throwable)e);
                throw new ServletException("Incoming SAML message is invalid", (Throwable)e);
            }
            catch (MetadataProviderException e) {
                this.logger.debug((Object)"Error determining metadata contracts", (Throwable)e);
                throw new ServletException("Error determining metadata contracts", (Throwable)e);
            }
            catch (MessageDecodingException e) {
                this.logger.debug((Object)"Error decoding incoming SAML message", (Throwable)e);
                throw new ServletException("Error decoding incoming SAML message", (Throwable)e);
            }
            catch (SecurityException e) {
                this.logger.debug((Object)"Incoming SAML message is invalid", (Throwable)e);
                throw new ServletException("Incoming SAML message is invalid", (Throwable)e);
            }
            if (context.getInboundSAMLMessage() instanceof LogoutResponse) {
                try {
                    this.logoutProfile.processLogoutResponse(context);
                    log.debug("Performing local logout after receiving logout response from {}", (Object)context.getPeerEntityId());
                    super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
                    this.samlLogger.log("LogoutResponse", "SUCCESS", context);
                }
                catch (Exception e) {
                    log.debug("Received logout response is invalid", (Throwable)e);
                    this.samlLogger.log("LogoutResponse", "FAILURE", context, e);
                }
            } else if (context.getInboundSAMLMessage() instanceof LogoutRequest) {
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                SAMLCredential credential = null;
                if (auth != null) {
                    credential = (SAMLCredential)auth.getCredentials();
                }
                try {
                    boolean doLogout;
                    try {
                        doLogout = this.logoutProfile.processLogoutRequest(context, credential);
                    }
                    catch (SAMLStatusException e) {
                        log.debug("Received logout request is invalid, responding with error", (Throwable)((Object)e));
                        this.logoutProfile.sendLogoutResponse(context, e.getStatusCode(), e.getStatusMessage());
                        this.samlLogger.log("LogoutRequest", "FAILURE", context, (Exception)((Object)e));
                        return;
                    }
                    if (doLogout) {
                        log.debug("Performing local logout after receiving logout request from {}", (Object)context.getPeerEntityId());
                        for (LogoutHandler handler : this.handlers) {
                            handler.logout(request, response, auth);
                        }
                    }
                    this.logoutProfile.sendLogoutResponse(context, "urn:oasis:names:tc:SAML:2.0:status:Success", null);
                    this.samlLogger.log("LogoutRequest", "SUCCESS", context);
                }
                catch (Exception e) {
                    log.debug("Error processing logout request", (Throwable)e);
                    this.samlLogger.log("LogoutRequest", "FAILURE", context, e);
                    throw new ServletException("Error processing logout request", (Throwable)e);
                }
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String getProfileName() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout";
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        return SAMLUtil.processFilter(this.getFilterProcessesUrl(), request);
    }

    public String getFilterProcessesUrl() {
        return super.getFilterProcessesUrl();
    }

    @Autowired
    public void setSAMLProcessor(SAMLProcessor processor) {
        Assert.notNull((Object)processor, (String)"SAML Processor can't be null");
        this.processor = processor;
    }

    @Autowired
    public void setLogoutProfile(SingleLogoutProfile logoutProfile) {
        Assert.notNull((Object)logoutProfile, (String)"SingleLogoutProfile can't be null");
        this.logoutProfile = logoutProfile;
    }

    @Autowired
    public void setSamlLogger(SAMLLogger samlLogger) {
        Assert.notNull((Object)samlLogger, (String)"SAML logger can't be null");
        this.samlLogger = samlLogger;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        Assert.notNull((Object)contextProvider, (String)"Context provider can't be null");
        this.contextProvider = contextProvider;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.processor, (String)"SAMLProcessor must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
        Assert.notNull((Object)this.logoutProfile, (String)"Logout profile must be set");
        Assert.notNull((Object)this.samlLogger, (String)"SAML Logger must be set");
    }
}

