/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.subjectDataCleaner;

import com.opencsv.CSVReader;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.StandaloneSubjectService;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.security.Key;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
class SubjectDataDeleter {
    public static final String DELETED_BY_SUBJECT_DATA_CLEAN_UP_PROGRAM_SUBJECT_DATA_DELETER = "Deleted by subject data clean-up program (SubjectDataDeleter)";
    protected final SubjectDAO subjectDAO;
    protected final StandaloneSubjectService standaloneSubjectService;
    @Option(name="-help", required=false, usage="outputs usage info")
    boolean help = false;
    @Option(name="-noDecrypt", required=false, usage="do not decrypt subjects")
    boolean noDecrypt = false;
    @Argument(index=0, required=true, usage="the input file, containing a single MRN per line (with NO spaces)")
    String inputFileName;
    final Date today;
    final String todayString;
    final long todayMilliseconds;
    boolean decrypt = true;
    static final Logger log = Logger.getLogger(SubjectDataDeleter.class);

    public static void main(String[] args) {
        LogManager.getRootLogger().setLevel(Level.ERROR);
        LogManager.getLogger(SubjectDataDeleter.class).setLevel(Level.INFO);
        try {
            Date startDate = new Date();
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-subject-data-cleaner.xml");
            SubjectDataDeleter subjectDataCleaner = (SubjectDataDeleter)context.getBean("subjectDataDeleter");
            subjectDataCleaner.setUp(args);
            subjectDataCleaner.readCsvAndDeleteSubjects();
            Date endDate = new Date();
            long elapsed = endDate.getTime() - startDate.getTime();
            log.info((Object)("Executed in " + elapsed / 1000L + " seconds"));
        }
        catch (Exception e) {
            log.error((Object)"The following exception/error was thrown:\n", (Throwable)e);
        }
    }

    @Autowired
    SubjectDataDeleter(@Qualifier(value="encryptionKeyForSubjectDataCleanUp") Key key, SubjectDAO subjectDAO, StandaloneSubjectService standaloneSubjectService) {
        this.subjectDAO = subjectDAO;
        this.standaloneSubjectService = standaloneSubjectService;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
        this.today = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        this.todayString = dateFormat.format(this.today);
        this.todayMilliseconds = this.today.getTime();
    }

    private void setUp(String[] args) throws IOException {
        this.parseCommandLineAndExitIfNeeded(args);
        log.info((Object)("Running Subject Data Cleaner on " + this.todayString + " with the following input parameters:"));
        log.info((Object)("decrypt: " + this.decrypt));
        log.info((Object)("input file: " + this.inputFileName));
    }

    void parseCommandLineAndExitIfNeeded(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            if (this.help) {
                this.printUsageAndExampleCommandLine(parser);
                System.exit(0);
            }
        }
        catch (CmdLineException e) {
            log.error((Object)e.getMessage());
            this.printUsageAndExampleCommandLine(parser);
            System.exit(-1);
        }
        this.decrypt = !this.noDecrypt;
    }

    void printUsageAndExampleCommandLine(CmdLineParser parser) {
        System.err.println("Usage:");
        System.err.println("  java " + this.getClass().getName() + " [options...]");
        System.err.println("where the options are:");
        parser.printUsage((OutputStream)System.err);
        System.err.println("  Example: java " + this.getClass().getName() + " " + parser.printExample(ExampleMode.ALL));
    }

    void readCsvAndDeleteSubjects() throws SQLException, IOException {
        CharSequence[] nextLine;
        CSVReader csvReader = new CSVReader((Reader)new FileReader(this.inputFileName));
        int rowNumber = 0;
        while ((nextLine = csvReader.readNext()) != null) {
            ++rowNumber;
            if (nextLine.length != 1) {
                log.error((Object)("CSV input row number " + rowNumber + " has " + nextLine.length + " values instead of 1: " + String.join((CharSequence)", ", nextLine)));
                continue;
            }
            String idString = nextLine[0];
            try {
                int id = Integer.parseInt(idString.trim());
                this.deleteSubject(id, rowNumber);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Cannot parse subject ID " + idString + " at line " + rowNumber));
            }
        }
        log.info((Object)"");
        csvReader.close();
    }

    public void deleteSubject(int subjectId, int rowNumber) {
        Subject subject = (Subject)this.subjectDAO.findById(Subject.class, Integer.valueOf(subjectId));
        if (null == subject) {
            log.error((Object)("  At line " + rowNumber + " the following subject ID has no match (it may have been previously deleted): " + subjectId));
        } else {
            String mrn = "none found";
            Set mrns = subject.getSubjectMrnSet();
            Iterator iterator = mrns.iterator();
            if (iterator.hasNext()) {
                mrn = ((SubjectMrn)iterator.next()).getMrn();
                if (this.decrypt) {
                    mrn = SubjectDataEncryptor.decrypt((String)mrn);
                }
                if (iterator.hasNext()) {
                    log.error((Object)("Subject with ID " + subjectId + " has multiple MRNs, therefore it was NOT DELETED"));
                    return;
                }
            }
            this.standaloneSubjectService.markArchivalStatus(subject, DELETED_BY_SUBJECT_DATA_CLEAN_UP_PROGRAM_SUBJECT_DATA_DELETER, "Subject ID: " + subjectId + " (MRN: " + mrn + ") archived (DELETED)", ArchivalStatus.DELETED);
            log.info((Object)("Archived (deleted) subject with ID " + subjectId + " (MRN: " + mrn + ")"));
        }
    }
}

