/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="template_resource_annotations")
public class TemplateResourceAnnotations
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 7967883768282015803L;
    private TemplateResource templateResource;
    private LineLevelAnnotations lineLevelAnnotations;
    private Integer quantity;
    private String comment;

    @JoinColumn(name="template_resource", referencedColumnName="id")
    @ManyToOne(optional=true)
    public TemplateResource getTemplateResource() {
        return this.templateResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    @JoinColumn(name="line_level_annotations", referencedColumnName="id")
    @ManyToOne(optional=true)
    public LineLevelAnnotations getLineLevelAnnotations() {
        return this.lineLevelAnnotations;
    }

    public void setLineLevelAnnotations(LineLevelAnnotations lineLevelAnnotations) {
        this.lineLevelAnnotations = lineLevelAnnotations;
    }

    @Column(name="quantity")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Transient
    public String getQuantifiedLlaName() {
        return this.lineLevelAnnotations.getName() + " (" + this.quantity + ")";
    }

    public String toString() {
        return "TemplateResourceAnnotations [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateResourceAnnotations other = (TemplateResourceAnnotations)obj;
        if (this.id == null && other.id == null) {
            return true;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id) && this.lineLevelAnnotations.equals(other.lineLevelAnnotations) && this.templateResource.equals(other.templateResource) && this.quantity.equals(other.quantity) && this.comment.equals(other.comment);
        }
        return this.lineLevelAnnotations.equals(other.lineLevelAnnotations) && this.templateResource.equals(other.templateResource) && this.quantity.equals(other.quantity) && this.comment.equals(other.comment);
    }

    @Override
    public final int hashCode() {
        int hash = 0;
        hash += this.lineLevelAnnotations != null ? this.lineLevelAnnotations.hashCode() : 0;
        hash += this.templateResource != null ? this.templateResource.hashCode() : 0;
        hash += this.quantity != null ? this.quantity.hashCode() : 0;
        return hash += this.comment != null ? this.comment.hashCode() : 0;
    }
}

