/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WorkloadAndResourceResponseDTO
implements Serializable,
CsvAbleDTO {
    private Integer visitId;
    private String studyName;
    private String visitName;
    private String nursing;
    private String nutrition;
    private String processing;
    private String setup;
    private String visitType;
    private Integer duration;
    private String resourceName;

    public Integer getVisitId() {
        return this.visitId;
    }

    public void setVisitId(Integer visitId) {
        this.visitId = visitId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getNursing() {
        return this.nursing;
    }

    public void setNursing(String nursing) {
        this.nursing = nursing;
    }

    public String getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(String nutrition) {
        this.nutrition = nutrition;
    }

    public String getProcessing() {
        return this.processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }

    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = setup;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(VisitType visitType) {
        this.visitType = visitType.getName();
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String toString() {
        return "{\"visitId\":" + this.visitId + ",\"visitName\":\"" + this.visitName + "\",\"nursing\":\"" + this.nursing + "\",\"nutrition\":\"" + this.nutrition + "\",\"processing\":\"" + this.processing + "\",\"setup\":\"" + this.setup + "\",\"duration\":" + this.duration + ",\"resourceName\":\"" + this.resourceName + "\",\"studyName\":\"" + this.studyName + "\",\"visitType\":\"" + this.visitType + "\"}";
    }

    @Override
    public String toCsvHeaders() {
        StringBuilder builder = new StringBuilder();
        builder.append("Visit Name,Visit Type,Local ID,Nursing,");
        builder.append("Nutrition,Processing,Setup,");
        for (int i = 0; i < 9; ++i) {
            builder.append("Resource Name,Resource Duration,");
        }
        builder.append("Resource Name,Resource Duration");
        return builder.toString();
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        Integer previousId = -1;
        List<Object> columns = Lists.newArrayList();
        for (Object object : dtoList) {
            WorkloadAndResourceResponseDTO d = (WorkloadAndResourceResponseDTO)object;
            if (!d.visitId.equals(previousId)) {
                if (!previousId.equals(-1)) {
                    columns = this.harvestNonEmptyColumns((List<String>)columns, result);
                }
                previousId = d.visitId;
                columns.add(MiscUtil.q(d.visitName));
                columns.add(MiscUtil.q(d.visitType));
                columns.add(MiscUtil.q(d.studyName));
                columns.add(MiscUtil.q(d.nursing));
                columns.add(MiscUtil.q(d.nutrition));
                columns.add(MiscUtil.q(d.processing));
                columns.add(MiscUtil.q(d.setup));
            }
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.formatMinsIntoDaysHrsMins(d.duration)));
        }
        this.harvestNonEmptyColumns((List<String>)columns, result);
        return result;
    }

    List<String> harvestNonEmptyColumns(List<String> columns, List<String> output) {
        if (!columns.isEmpty()) {
            String rows = Joiner.on((String)",").join(columns);
            output.add(rows + "\n");
        }
        return Lists.newArrayList();
    }
}

