/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.util.DateUtility;

public class BookedVisitDetailResponse {
    private Integer id;
    private String studyName;
    private int visitDuration;
    private int appointmentStatusId;
    private String appointmentStatus;
    private String scheduledStartTime;
    private String scheduledEndTime;
    private String checkInDate;
    private String checkOutDate;
    private String cancelDate;
    private String checkOutReason;
    private String cancelReason;
    private String localId;
    private String subjectName;
    private String catID;
    private String subjectMRN;
    private String irb;
    private String genderName;
    private String visitName;
    private String birthDate;
    private String comment;
    private String visitTypeName;

    public BookedVisitDetailResponse(BookedVisit bookedVisit) {
        if (bookedVisit == null) {
            SchedulerRuntimeException.logAndThrow("BookedVisit parameter should be non-null");
        }
        this.id = bookedVisit.getId();
        this.appointmentStatus = bookedVisit.getAppointmentStatus().getName();
        this.appointmentStatusId = bookedVisit.getAppointmentStatus().getId();
        if (bookedVisit.getStudySubject().getSubject().getBirthdate() != null) {
            this.birthDate = DateUtility.format(DateUtility.monthDayYear(), bookedVisit.getStudySubject().getSubject().getBirthdate());
        }
        this.cancelDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCancelDate());
        if (bookedVisit.getCancelStatusReason() != null) {
            this.cancelReason = bookedVisit.getCancelStatusReason().getName();
        }
        this.catID = bookedVisit.getStudy().getCatalystId();
        this.checkInDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCheckInDate());
        this.checkOutDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCheckOutDate());
        if (bookedVisit.getCheckoutStatusReason() != null) {
            this.checkOutReason = bookedVisit.getCheckoutStatusReason().getName();
        }
        this.comment = bookedVisit.getComment();
        this.genderName = bookedVisit.getStudySubject().getSubject().getGender().getName();
        this.irb = bookedVisit.getStudy().getIrb();
        this.localId = bookedVisit.getStudy().getLocalId();
        this.scheduledEndTime = DateUtility.format(DateUtility.dateTime(), bookedVisit.getScheduledEndTime());
        this.scheduledStartTime = DateUtility.format(DateUtility.dateTime(), bookedVisit.getScheduledStartTime());
        this.studyName = bookedVisit.getStudy().getName();
        this.subjectMRN = bookedVisit.getStudySubject().getSubject().getMrn();
        this.subjectName = bookedVisit.getStudySubject().getSubject().getFirstName() + " " + bookedVisit.getStudySubject().getSubject().getLastName();
        this.visitDuration = bookedVisit.getVisitTemplate().getDuration();
        this.visitName = bookedVisit.getVisitTemplate().getName();
        this.visitTypeName = bookedVisit.getVisitTemplate().getVisitType().getName();
    }
}

