/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.Date;

public class OverbookedResourcesResponse {
    private int id;
    private int totalCount;
    private String localId;
    private Date visitStartTime;
    private Date visitEndTime;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private String conflictedTime;
    private String subjectName;
    private String resourceName;
    private String visitName;

    public OverbookedResourcesResponse(BookedResource bookedResource, int totalCount) {
        this.id = bookedResource.getId();
        this.totalCount = totalCount;
        this.localId = bookedResource.getBookedVisit().getStudy().getLocalId();
        this.visitStartTime = bookedResource.getBookedVisit().getScheduledStartTime();
        this.visitEndTime = bookedResource.getBookedVisit().getScheduledEndTime();
        this.scheduledStartTime = bookedResource.getScheduledStartTime();
        this.scheduledEndTime = bookedResource.getScheduledEndTime();
        this.conflictedTime = bookedResource.getConflictedTime();
        Subject subject = bookedResource.getBookedVisit().getStudySubject().getSubject();
        this.subjectName = SubjectDataEncryptor.decrypt(subject.getFirstName()) + " " + SubjectDataEncryptor.decrypt(subject.getLastName());
        this.resourceName = bookedResource.getResource().getName();
        this.visitName = bookedResource.getBookedVisit().getVisitTemplate().getName();
    }
}

