/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="booked_resource")
public class BookedResource
extends BaseEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Integer duration;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private BookedVisit bookedVisit;
    private TemplateResource templateResource;
    private Resource resource;
    private String conflictedTime;
    private String visitName;
    private String subjectName;
    private String localId;
    private Date visitStartTime;
    private Date visitEndTime;
    private String annotations;
    private Boolean billable;
    private String rejectedResourceMessage;
    private String available;

    @Deprecated
    public BookedResource() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public BookedResource(Integer duration, Date scheduledStartTime, Date scheduledEndTime, BookedVisit bookedVisit, TemplateResource templateResource, Resource resource, String conflictedTime, String visitName, String subjectName, String localId, Date visitStartTime, Date visitEndTime, Boolean billable) {
        super(null);
        this.duration = duration;
        this.scheduledStartTime = scheduledStartTime;
        this.scheduledEndTime = scheduledEndTime;
        this.bookedVisit = bookedVisit;
        this.templateResource = templateResource;
        this.resource = resource;
        this.conflictedTime = conflictedTime;
        this.visitName = visitName;
        this.subjectName = subjectName;
        this.localId = localId;
        this.visitStartTime = visitStartTime;
        this.visitEndTime = visitEndTime;
        this.billable = billable;
    }

    @JoinColumn(name="booked_visit", referencedColumnName="id")
    @ManyToOne(optional=false)
    public BookedVisit getBookedVisit() {
        return this.bookedVisit;
    }

    public void setBookedVisit(BookedVisit bookedVisit) {
        this.bookedVisit = bookedVisit;
    }

    @Column(name="duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Column(name="scheduled_start_time")
    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @Column(name="scheduled_end_time")
    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Column(name="billable")
    public Boolean getBillable() {
        return this.billable;
    }

    public void setBillable(Boolean billable) {
        this.billable = billable;
    }

    @JoinColumn(name="template_resource", referencedColumnName="id")
    @ManyToOne(optional=true)
    public TemplateResource getTemplateResource() {
        return this.templateResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    @JoinColumn(name="resource", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Transient
    public String getConflictedTime() {
        return this.conflictedTime;
    }

    public void setConflictedTime(String conflictedTime) {
        this.conflictedTime = conflictedTime;
    }

    @Transient
    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Transient
    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    @Transient
    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    @Transient
    public Date getVisitStartTime() {
        return this.visitStartTime;
    }

    public void setVisitStartTime(Date visitStartTime) {
        this.visitStartTime = visitStartTime;
    }

    @Transient
    public Date getVisitEndTime() {
        return this.visitEndTime;
    }

    public void setVisitEndTime(Date visitEndTime) {
        this.visitEndTime = visitEndTime;
    }

    @Transient
    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public BookedResource cloneBookedResource() {
        BookedResource clone = null;
        try {
            clone = (BookedResource)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            SchedulerRuntimeException.logAndThrow("Couldn't clone BookedResource '" + this.getId() + "'", cnse);
        }
        return clone;
    }

    @Transient
    public String getRejectedResourceMessage() {
        return this.rejectedResourceMessage;
    }

    public void setRejectedResourceMessage(String rejectedResourceMessage) {
        this.rejectedResourceMessage = rejectedResourceMessage;
    }

    @Transient
    public String getAvailable() {
        return this.available;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public String toString() {
        return "BookedResource [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

