/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="booked_visit")
public class BookedVisit
extends BaseEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Study study;
    private VisitTemplate visitTemplate;
    private String name;
    private VisitType visitType;
    private StudySubject studySubject;
    private AppointmentStatus appointmentStatus;
    private CancellationStatus cancelStatus;
    private AppointmentStatusReason appointmentStatusReason;
    private AppointmentStatusReason cancelStatusReason;
    private AppointmentStatusReason checkoutStatusReason;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private Date checkInDate;
    private Date checkOutDate;
    private Date cancelDate;
    private String comment;
    private String checkoutStatusReasonName;
    private int total;
    private int size;
    private int limit;
    private int start;
    private String sessionId;
    private String uniquekey;
    private Date scheduleDate;
    private String userdata;
    private String scheduledata;
    private Date schedulingTime;
    private String schedulingFlavor;
    private String schedulingUserEcommonsId;
    private List<BookedResource> bookedResourceList;
    private Resource selectedRoom;
    private boolean varyDuration;
    private boolean ommittedActivities;
    private String rooms;
    private String errorMsg;
    private boolean rejectedVisit;

    @Deprecated
    public BookedVisit() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, 0, 0, null, null, null, null, null, null, null, null);
    }

    public BookedVisit(Study study, VisitTemplate visitTemplate, String name, VisitType visitType, StudySubject studySubject, AppointmentStatus appointmentStatus, CancellationStatus cancelStatus, AppointmentStatusReason appointmentStatusReason, AppointmentStatusReason cancelStatusReason, AppointmentStatusReason checkoutStatusReason, Date scheduledStartTime, Date scheduledEndTime, Date checkInDate, Date checkOutDate, Date cancelDate, String comment, Date scheduleDate, String checkoutStatusReasonName, int total, int size, int limit, int start, String sessionId, String uniquekey, String userdata, String scheduledata, List<BookedResource> bookedResourceList, Resource selectedRoom, String rooms, String errorMsg) {
        super(null);
        this.study = study;
        this.visitTemplate = visitTemplate;
        this.name = name;
        this.visitType = visitType;
        this.studySubject = studySubject;
        this.appointmentStatus = appointmentStatus;
        this.cancelStatus = cancelStatus;
        this.appointmentStatusReason = appointmentStatusReason;
        this.cancelStatusReason = cancelStatusReason;
        this.checkoutStatusReason = checkoutStatusReason;
        this.scheduledStartTime = scheduledStartTime;
        this.scheduledEndTime = scheduledEndTime;
        this.checkInDate = checkInDate;
        this.checkOutDate = checkOutDate;
        this.cancelDate = cancelDate;
        this.comment = comment;
        this.scheduleDate = scheduleDate;
        this.checkoutStatusReasonName = checkoutStatusReasonName;
        this.total = total;
        this.size = size;
        this.limit = limit;
        this.start = start;
        this.sessionId = sessionId;
        this.uniquekey = uniquekey;
        this.userdata = userdata;
        this.scheduledata = scheduledata;
        this.bookedResourceList = bookedResourceList;
        this.selectedRoom = selectedRoom;
        this.rooms = rooms;
        this.errorMsg = errorMsg;
    }

    @JoinColumn(name="study", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    @JoinColumn(name="visit_template", referencedColumnName="id")
    @ManyToOne(optional=false)
    public VisitTemplate getVisitTemplate() {
        return this.visitTemplate;
    }

    public void setVisitTemplate(VisitTemplate visitTemplate) {
        this.visitTemplate = visitTemplate;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="type")
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    public VisitType getVisitType() {
        return this.visitType;
    }

    public void setVisitType(VisitType visitType) {
        this.visitType = visitType;
    }

    @JoinColumn(name="study_subject", referencedColumnName="id")
    @ManyToOne(optional=false)
    public StudySubject getStudySubject() {
        return this.studySubject;
    }

    public void setStudySubject(StudySubject studySubject) {
        this.studySubject = studySubject;
    }

    @JoinColumn(name="appointment_status", referencedColumnName="id")
    @ManyToOne(optional=false)
    public AppointmentStatus getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public void setAppointmentStatus(AppointmentStatus appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
    }

    @JoinColumn(name="appointment_status_reason", referencedColumnName="id")
    @ManyToOne(optional=true)
    public AppointmentStatusReason getAppointmentStatusReason() {
        return this.appointmentStatusReason;
    }

    public void setAppointmentStatusReason(AppointmentStatusReason appointmentStatusReason) {
        this.appointmentStatusReason = appointmentStatusReason;
    }

    @JoinColumn(name="cancel_status_reason", referencedColumnName="id")
    @ManyToOne(optional=true)
    public AppointmentStatusReason getCancelStatusReason() {
        return this.cancelStatusReason;
    }

    public void setCancelStatusReason(AppointmentStatusReason cancelStatusReason) {
        this.cancelStatusReason = cancelStatusReason;
    }

    @JoinColumn(name="checkout_status_reason", referencedColumnName="id")
    @ManyToOne(optional=true)
    public AppointmentStatusReason getCheckoutStatusReason() {
        return this.checkoutStatusReason;
    }

    public void setCheckoutStatusReason(AppointmentStatusReason checkoutStatusReason) {
        this.checkoutStatusReason = checkoutStatusReason;
    }

    @Column(name="scheduled_start_time")
    @Basic(optional=false)
    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @Column(name="scheduled_end_time")
    @Basic(optional=false)
    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="scheduling_user_ecommons_id")
    public String getSchedulingUserEcommonsId() {
        return this.schedulingUserEcommonsId;
    }

    public void setSchedulingUserEcommonsId(String schedulingUserEcommonsId) {
        this.schedulingUserEcommonsId = schedulingUserEcommonsId;
    }

    @Column(name="scheduling_flavor")
    public String getSchedulingFlavor() {
        return this.schedulingFlavor;
    }

    public void setSchedulingFlavor(String schedulingFlavor) {
        this.schedulingFlavor = schedulingFlavor;
    }

    @Column(name="scheduling_time")
    public Date getSchedulingTime() {
        return this.schedulingTime;
    }

    public void setSchedulingTime(Date schedulingTime) {
        this.schedulingTime = schedulingTime;
    }

    @Column(name="check_in_date")
    @Basic(optional=true)
    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    @Column(name="check_out_date")
    @Basic(optional=true)
    public Date getCheckOutDate() {
        return this.checkOutDate;
    }

    public void setCheckOutDate(Date checkOutDate) {
        this.checkOutDate = checkOutDate;
    }

    @Column(name="cancel_date")
    @Basic(optional=true)
    public Date getCancelDate() {
        return this.cancelDate;
    }

    public void setCancelDate(Date cancelDate) {
        this.cancelDate = cancelDate;
    }

    @JoinColumn(name="cancel_status", referencedColumnName="id")
    @ManyToOne(optional=true)
    public CancellationStatus getCancelStatus() {
        return this.cancelStatus;
    }

    public void setCancelStatus(CancellationStatus cancelStatus) {
        this.cancelStatus = cancelStatus;
    }

    @Column(name="vary_duration")
    public boolean isVaryDuration() {
        return this.varyDuration;
    }

    public void setVaryDuration(boolean varyDuration) {
        this.varyDuration = varyDuration;
    }

    @Column(name="ommitted_activities")
    public boolean isOmmittedActivities() {
        return this.ommittedActivities;
    }

    public void setOmmittedActivities(boolean ommittedActivities) {
        this.ommittedActivities = ommittedActivities;
    }

    @Transient
    public List<BookedResource> getBookedResourceList() {
        return this.bookedResourceList;
    }

    public void setBookedResourceList(List<BookedResource> bookedResourceList) {
        this.bookedResourceList = bookedResourceList;
    }

    @Transient
    public Date getScheduleDate() {
        return this.scheduleDate;
    }

    public void setScheduleDate(Date scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    @Transient
    public boolean isOutpatientVisit() {
        return this.visitType.isOutpatient();
    }

    @Transient
    public String getCheckoutStatusReasonName() {
        return this.checkoutStatusReasonName;
    }

    public void setCheckoutStatusReasonName(String checkoutStatusReasonName) {
        this.checkoutStatusReasonName = checkoutStatusReasonName;
    }

    @Transient
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Transient
    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    @Transient
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Transient
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Transient
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Transient
    public String getUniquekey() {
        return this.uniquekey;
    }

    public void setUniquekey(String uniquekey) {
        this.uniquekey = uniquekey;
    }

    @Transient
    public String getUserdata() {
        return this.userdata;
    }

    public void setUserdata(String userdata) {
        this.userdata = userdata;
    }

    @Transient
    public String getScheduledata() {
        return this.scheduledata;
    }

    public void setScheduledata(String string) {
        this.scheduledata = string;
    }

    @Transient
    public Resource getSelectedRoom() {
        return this.selectedRoom;
    }

    public void setSelectedRoom(Resource selectedRoom) {
        this.selectedRoom = selectedRoom;
    }

    @Transient
    public String getRooms() {
        return this.rooms;
    }

    public void setRooms(String rooms) {
        this.rooms = rooms;
    }

    @Transient
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Transient
    public boolean isRejectedVisit() {
        return this.rejectedVisit;
    }

    public void setRejectedVisit(boolean rejectedVisit) {
        this.rejectedVisit = rejectedVisit;
    }

    public BookedVisit cloneBookedVisit() {
        BookedVisit result = null;
        try {
            result = (BookedVisit)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            SchedulerRuntimeException.logAndThrow("Couldn't clone BookedVisit '" + this.getId() + "'", cnse);
        }
        return result;
    }

    public String toString() {
        return "BookedVisit [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

