/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponse;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SubjectDAO
extends SiteDAO {
    private static final Map<String, Comparator<SubjectsResponse>> descendingComparators = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"lastname", SubjectsResponse.SubjectLastNameComparatorDesc), Pair.pair((Object)"mrn", SubjectsResponse.SubjectMrnComparatorDesc), Pair.pair((Object)"firstname", SubjectsResponse.SubjectFirstNameComparatorDesc), Pair.pair((Object)"primarycontactnumber", SubjectsResponse.SubjectContactComparatorDesc), Pair.pair((Object)"birthdate", SubjectsResponse.SubjectBirthdateComparatorDesc), Pair.pair((Object)"city", SubjectsResponse.SubjectCityComparatorDesc)});
    private static final Map<String, Comparator<SubjectsResponse>> ascendingComparators = Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"lastname", SubjectsResponse.SubjectLastNameComparatorAsc), Pair.pair((Object)"mrn", SubjectsResponse.SubjectMrnComparatorAsc), Pair.pair((Object)"firstname", SubjectsResponse.SubjectFirstNameComparatorAsc), Pair.pair((Object)"primarycontactnumber", SubjectsResponse.SubjectContactComparatorAsc), Pair.pair((Object)"birthdate", SubjectsResponse.SubjectBirthdateComparatorAsc), Pair.pair((Object)"city", SubjectsResponse.SubjectCityComparatorAsc)});
    private static final Comparator<Subject> subjectComparator = (o1, o2) -> o1.getLastName().compareToIgnoreCase(o2.getLastName());

    public void createSubject(Subject entity) {
        Subject subject = entity == null ? null : SubjectDataEncryptor.encryptSubjectInPlace(entity);
        Session session = this.session();
        session.save((Object)subject);
        session.flush();
    }

    public void editSubject(Subject entity) {
        if (entity != null) {
            Subject subject = SubjectDataEncryptor.encryptSubjectInPlace(entity);
            Session session = this.session();
            session.update((Object)subject);
            session.flush();
        }
    }

    public List<Subject> findAllSubjectsHql() {
        String findSubjects = "SELECT s FROM Subject s ";
        return this.newQuery("SELECT s FROM Subject s ").list();
    }

    public List<Subject> findAllSubjects() {
        return this.newCriteria(Subject.class).list();
    }

    static final Predicate<Row> subjectsPredicate(Optional<String> normalizedFilterString) {
        boolean filterStringIsPresent = normalizedFilterString.isPresent();
        return row -> {
            if (filterStringIsPresent) {
                String filterStringToUse = (String)normalizedFilterString.get();
                boolean mrnMatches = ((Row)row).mrn.contains(filterStringToUse);
                boolean schedulerIdMatches = ((Row)row).schedulerId.isPresent() && ((String)((Row)row).schedulerId.get()).contains(filterStringToUse);
                boolean lastNameMatches = ((Row)row).lastName.contains(filterStringToUse);
                return mrnMatches || schedulerIdMatches || lastNameMatches;
            }
            return true;
        };
    }

    public SubjectsResponse getSubjectsList(String filterString, int maxResults, int page, String sortBy, String orderBy) {
        String findSubjects = "SELECT s.id, s.lastName, s.firstName, s.mrn, s.birthdate, s.city, s.primaryContactNumber, s.active, s.subjectSchedulerId FROM Subject s ";
        List resultRows = this.newQuery("SELECT s.id, s.lastName, s.firstName, s.mrn, s.birthdate, s.city, s.primaryContactNumber, s.active, s.subjectSchedulerId FROM Subject s ").list();
        Optional<String> normalizedFilterString = SubjectDAO.normalizeFilterString(filterString);
        Predicate<Row> matches = SubjectDAO.subjectsPredicate(normalizedFilterString);
        List subjectsResponses = ListUtils.enrich((List)resultRows).map(Row::fromArray).map(Row::decrypt).filter(matches).map(Row::toSubjectsResponse).toList();
        long total = subjectsResponses.size();
        this.sortSubjectData(sortBy, orderBy, subjectsResponses);
        List<SubjectsResponse> paginatedSubjectsResponses = this.paginateSubjectsResponses(maxResults, page, subjectsResponses, total);
        return new SubjectsResponse(paginatedSubjectsResponses, total);
    }

    static Optional<String> normalizeFilterString(String filterString) {
        return Optional.ofNullable(filterString).map(fs -> fs.trim().toUpperCase()).filter(fs -> !fs.isEmpty());
    }

    private List<SubjectsResponse> paginateSubjectsResponses(int maxResults, int page, List<SubjectsResponse> subjectsResponses, long total) {
        int offset = (page - 1) * maxResults;
        List<Object> subjects = (long)(offset + maxResults) <= total ? subjectsResponses.subList(offset, offset + maxResults) : ((long)(offset + maxResults) > total ? subjectsResponses.subList(offset, (int)total) : Lists.newArrayList());
        return subjects;
    }

    private static final String encryptIgnoringLiteralNulls(String rawField) {
        if (!SubjectDAO.isLiteralNull(rawField)) {
            return SubjectDataEncryptor.encrypt(rawField.toUpperCase());
        }
        return null;
    }

    public SubjectsResponse getStudyStaffSubjects(String lastName, String mrn, String bday, String subjectSchedulerId, String sortBy, String orderBy, String ipAddress, User user) {
        String encName = SubjectDAO.encryptIgnoringLiteralNulls(lastName);
        String encMrn = SubjectDAO.encryptIgnoringLiteralNulls(mrn);
        String encSchedulerId = SubjectDAO.encryptIgnoringLiteralNulls(subjectSchedulerId);
        Date date = !SubjectDAO.isLiteralNull(bday) ? DateUtility.parse(DateUtility.monthDayYear(), bday) : null;
        List<SubjectsResponse> resultRows = this.findSubjectByLastNameMrnBdate(encName, encMrn, date, encSchedulerId);
        Long total = resultRows.size();
        this.sortSubjectData(sortBy, orderBy, resultRows);
        return new SubjectsResponse(resultRows, total);
    }

    private static boolean isLiteralNull(String lastName) {
        return lastName.equalsIgnoreCase("null");
    }

    void sortSubjectData(String sortBy, String orderBy, List<SubjectsResponse> resultRows) {
        if (orderBy.equalsIgnoreCase("ASC")) {
            SubjectDAO.sortSubjectDataASC(sortBy, resultRows);
        } else if (orderBy.equalsIgnoreCase("DESC")) {
            SubjectDAO.sortSubjectDataDESC(sortBy, resultRows);
        }
    }

    private static void sortSubjectDataDESC(String sortBy, List<SubjectsResponse> resultRows) {
        SubjectDAO.sortSubjectData(sortBy, resultRows, descendingComparators);
    }

    private static void sortSubjectDataASC(String sortBy, List<SubjectsResponse> resultRows) {
        SubjectDAO.sortSubjectData(sortBy, resultRows, ascendingComparators);
    }

    private static void sortSubjectData(String sortBy, List<SubjectsResponse> resultRows, Map<String, Comparator<SubjectsResponse>> comparatorsByField) {
        String normalizedSortBy = sortBy.toLowerCase();
        if (comparatorsByField.containsKey(normalizedSortBy)) {
            Comparator<SubjectsResponse> ordering = comparatorsByField.get(normalizedSortBy);
            Collections.sort(resultRows, ordering);
        }
    }

    public Subject findBySubjectId(int id) {
        Subject subject = this.findById(Subject.class, id);
        return SubjectDataEncryptor.decryptSubject(subject);
    }

    public SubjectDetailResponse getSubjectDataById(int subjectId) {
        Subject subject = this.findBySubjectId(subjectId);
        Subject subjectCopy = Subject.defensiveCopy(subject);
        return new SubjectDetailResponse(subjectCopy);
    }

    public StudySubject findStudySubjectById(Integer id) {
        StudySubject studySubject = this.findById(StudySubject.class, id);
        if (studySubject != null) {
            SubjectDataEncryptor.decryptSubjectWithinStudySubject(studySubject);
        }
        return studySubject;
    }

    public List<Subject> filterSubjectByLastNames(String lastName) {
        String encName = lastName == null ? null : SubjectDataEncryptor.encrypt(lastName.toUpperCase());
        List<Subject> list = this.findSubjectByLastNames(encName);
        if (list != null) {
            return ListUtils.enrich(list).map(SubjectDataEncryptor::decryptSubject).toList();
        }
        return new ArrayList<Subject>();
    }

    public List<Subject> getSubjectByLastName(String lastName, InstitutionRole institutionRole) {
        boolean isStudyStaff = InstitutionRole.isStudyStaff(institutionRole);
        Predicate<Subject> matches = subject -> isStudyStaff ? SubjectDAO.lastNameIs(subject, lastName) : SubjectDAO.lastNameMatches(subject, lastName);
        List<Subject> subjects = this.findAllSubjects();
        return ListUtils.enrich(subjects).map(SubjectDataEncryptor::decryptSubject).filter(matches).toList();
    }

    private static boolean lastNameIs(Subject subject, String lastName) {
        return subject.getLastName().equalsIgnoreCase(lastName);
    }

    private static boolean lastNameMatches(Subject subject, String lastName) {
        return subject.getLastName().toLowerCase().contains(lastName.toLowerCase());
    }

    public List<Subject> filterSubjectsByMRN(String mrn, InstitutionRole institutionRole) {
        if (mrn != null) {
            List<Subject> encryptedList = this.findAllSubjects();
            RichList decryptedList = ListUtils.enrich(encryptedList).map(SubjectDataEncryptor::decryptSubject);
            boolean isStudyStaff = InstitutionRole.isStudyStaff(institutionRole);
            Predicate<Subject> shouldBeReturned = subject -> isStudyStaff ? SubjectDAO.mrnIs(subject, mrn) : SubjectDAO.mrnMatches(subject, mrn);
            return decryptedList.sortWith(subjectComparator).filter(shouldBeReturned).toList();
        }
        return new ArrayList<Subject>();
    }

    private static boolean mrnIs(Subject subject, String mrn) {
        return subject.getMrn().equalsIgnoreCase(mrn);
    }

    private static boolean mrnMatches(Subject subject, String mrn) {
        return subject.getMrn().contains(mrn.toUpperCase());
    }

    public List<State> getStates() {
        return this.findAll(State.class);
    }

    public List<Race> getRaces() {
        return this.findAll(Race.class);
    }

    public List<Ethnicity> getEthnicities() {
        return this.findAll(Ethnicity.class);
    }

    public List<Gender> getGenders() {
        return this.findAll(Gender.class);
    }

    public List<Country> getCountries() {
        return this.findAll(Country.class);
    }

    public List<SubjectsResponse> findSubjectByLastNameMrnBdate(String lastName, String medicalRecordNumber, Date birthDate, String schedulerId) {
        String findSubjects = "SELECT s.id, s.lastName, s.firstName, s.mrn, s.birthdate, s.city, s.primaryContactNumber, s.active FROM Subject s " + this.findSubjectsWhereClause(lastName, medicalRecordNumber, birthDate, schedulerId);
        Query query = this.newQuery(findSubjects);
        this.setQueryParameters(query, lastName, medicalRecordNumber, birthDate, schedulerId);
        List resultRows = query.list();
        return ListUtils.enrich((List)resultRows).map(Row::fromArray).map(Row::decrypt).map(Row::toSubjectsResponse).toList();
    }

    private void setQueryParameters(Query query, String lastName, String medicalRecordNumber, Date birthDate, String schedulerId) {
        if (lastName != null) {
            query.setParameter("lastName", (Object)lastName);
        }
        if (medicalRecordNumber != null) {
            query.setParameter("medicalRecordNumber", (Object)medicalRecordNumber);
        }
        if (birthDate != null) {
            query.setParameter("birthDate", (Object)birthDate);
        }
        if (schedulerId != null) {
            query.setParameter("schedulerId", (Object)schedulerId);
        }
    }

    private String findSubjectsWhereClause(String lastName, String medicalRecordNumber, Date birthDate, String schedulerId) {
        String whereClause = lastName != null && medicalRecordNumber != null && birthDate != null && schedulerId != null ? " WHERE s.lastName = :lastName and s.mrn = :medicalRecordNumber and s.birthdate = :birthDate and s.subjectSchedulerId = :schedulerId" : (lastName != null && medicalRecordNumber != null && schedulerId != null ? " WHERE s.lastName = :lastName and s.mrn = :medicalRecordNumber and s.subjectSchedulerId = :schedulerId" : (lastName != null && birthDate != null && schedulerId != null ? " WHERE s.lastName = :lastName and s.birthdate = :birthDate and s.subjectSchedulerId = :schedulerId" : (medicalRecordNumber != null && birthDate != null && schedulerId != null ? " WHERE s.mrn = :medicalRecordNumber and s.birthdate = :birthDate and s.subjectSchedulerId = :schedulerId" : (medicalRecordNumber != null && birthDate != null && lastName != null ? " WHERE s.lastName = :lastName and s.mrn = :medicalRecordNumber and s.birthdate = :birthDate" : (lastName != null && medicalRecordNumber != null ? " WHERE s.lastName = :lastName and s.mrn = :medicalRecordNumber" : (lastName != null && birthDate != null ? " WHERE s.lastName = :lastName and s.birthdate = :birthDate" : (medicalRecordNumber != null && birthDate != null ? " WHERE s.mrn = :medicalRecordNumber and s.birthdate = :birthDate" : (medicalRecordNumber != null && schedulerId != null ? " WHERE s.mrn = :medicalRecordNumber and s.subjectSchedulerId = :schedulerId" : (lastName != null && schedulerId != null ? " WHERE s.lastName = :lastName and s.subjectSchedulerId = :schedulerId" : (birthDate != null && schedulerId != null ? " WHERE s.birthdate = :birthDate and s.subjectSchedulerId = :schedulerId" : ""))))))))));
        return whereClause;
    }

    public List<Subject> findSubjectByLastNames(String lastName) {
        Criteria crit = this.newCriteria(Subject.class);
        crit.add((Criterion)Restrictions.eq((String)"lastName", (Object)lastName));
        return crit.list();
    }

    public boolean checkMrn(String mrn) {
        return this.checkField("mrn", mrn);
    }

    public boolean checkSubjectSchedulerId(String subjectSchedulerId) {
        return this.checkField("subjectSchedulerId", subjectSchedulerId);
    }

    private boolean checkField(String fieldName, String fieldValue) {
        String encryptedFieldValue = SubjectDataEncryptor.encrypt(fieldValue.toUpperCase());
        Criteria crit = this.newCriteria(Subject.class);
        crit.add((Criterion)Restrictions.eq((String)fieldName, (Object)encryptedFieldValue));
        Subject subject = (Subject)crit.uniqueResult();
        return subject == null;
    }

    public Gender findByGenderId(Integer id) {
        return this.findById(Gender.class, id);
    }

    public Race findByRaceId(Integer id) {
        return this.findById(Race.class, id);
    }

    public Ethnicity findByEthnicityId(Integer id) {
        return this.findById(Ethnicity.class, id);
    }

    public State findByStateId(Integer id) {
        return this.findById(State.class, id);
    }

    public Country findCountryById(Integer id) {
        return this.findById(Country.class, id);
    }

    static final class Row {
        private final Integer id;
        private final String lastName;
        private final String firstName;
        private final String mrn;
        private final Date dob;
        private final String city;
        private final String primaryContact;
        private final Boolean status;
        private final Optional<String> schedulerId;

        public Row(Integer id, String lastName, String firstName, String mrn, Date dob, String city, String primaryContact, Boolean status, Optional<String> schedulerId) {
            this.id = id;
            this.lastName = lastName;
            this.firstName = firstName;
            this.mrn = mrn;
            this.dob = dob;
            this.city = city;
            this.primaryContact = primaryContact;
            this.status = status;
            this.schedulerId = schedulerId;
        }

        public static Row fromArray(Object[] resultRow) {
            return new Row((Integer)resultRow[0], (String)resultRow[1], (String)resultRow[2], (String)resultRow[3], (Date)resultRow[4], (String)resultRow[5], (String)resultRow[6], (Boolean)resultRow[7], resultRow.length >= 9 ? Optional.of((String)resultRow[8]) : Optional.empty());
        }

        public Row decrypt() {
            return new Row(this.id, SubjectDataEncryptor.decrypt(this.lastName), SubjectDataEncryptor.decrypt(this.firstName), SubjectDataEncryptor.decrypt(this.mrn), this.dob, SubjectDataEncryptor.decrypt(this.city), SubjectDataEncryptor.decrypt(this.primaryContact).replaceAll("[^a-zA-Z0-9]+", ""), this.status, this.schedulerId.map(SubjectDataEncryptor::decrypt));
        }

        public SubjectsResponse toSubjectsResponse() {
            return new SubjectsResponse(this.id, this.lastName, this.firstName, this.mrn, this.dob, this.city, this.primaryContact, this.status);
        }
    }
}

