/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.security.SchedulerSession;
import java.lang.reflect.Type;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

@Produces(value={"text/plain"})
public class BaseResource {
    protected final Gson gson;
    @Context
    protected HttpServletRequest request;
    @Autowired
    private SchedulerSession session;

    void setSession(SchedulerSession session) {
        this.session = session;
    }

    void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public BaseResource() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                return new Date(json.getAsJsonPrimitive().getAsLong());
            }
        });
        this.gson = builder.create();
    }

    protected User getUser() {
        return this.session.getUserDetails().getUser();
    }

    protected UserSession getUserSession() {
        return this.session.getUserDetails().getUserSession();
    }

    protected void updateUserSession(UserSession us) {
        this.session.getUserDetails().setUserSession(us);
    }

    protected String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    protected String getServerName() {
        return this.request.getServerName();
    }

    protected int getServerPort() {
        return this.request.getServerPort();
    }

    protected String getContextPath() {
        return this.request.getContextPath();
    }
}

