/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectsDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponse;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.SubjectService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.Date;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/subject")
@Singleton
@Component
public class SubjectResource
extends SecuredResource {
    private final SubjectService service;

    @Autowired
    public SubjectResource(SubjectService service) {
        this.service = service;
    }

    SubjectResource() {
        this(null);
    }

    @GET
    @Path(value="/getSubjects")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSubjects(@QueryParam(value="filterString") String filterString, @QueryParam(value="study") String study, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy) {
        SubjectsResponse subjects = this.service.getSubjects(filterString, maxResults, page, sortBy, orderBy);
        return this.gson.toJson((Object)subjects);
    }

    @GET
    @Path(value="/getSubjectData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSubjectData(@QueryParam(value="id") int subjectId) {
        SubjectDetailResponse subject = this.service.getSubjectData(subjectId, this.getRemoteHost(), this.getUser());
        return this.gson.toJson((Object)subject);
    }

    @GET
    @Path(value="/getSearchSubjects")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSearchSubjects(@QueryParam(value="lastName") String subjectLastName, @QueryParam(value="mrn") String subjectMrn, @QueryParam(value="birthdate") String subjectBirthdate, @QueryParam(value="schedulerId") String subjectSchedulerId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy) {
        SubjectsResponse subjects = this.service.getSearchedSubjects(subjectLastName, subjectMrn, subjectBirthdate, subjectSchedulerId, this.getRemoteHost(), this.getUser(), sortBy, orderBy);
        return this.gson.toJson((Object)subjects);
    }

    @POST
    @Path(value="/createSubject")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String createSubject(@FormParam(value="data") String data, @HeaderParam(value="User-Agent") String header) {
        SubjectsDTO s = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        Date birthdate = this.getFormattedBirthDate(header, s.getBirthday());
        s.setBirthdate(birthdate);
        s = this.service.createSubject(s, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)s);
    }

    @POST
    @Path(value="/updateSubject")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String updateSubject(@FormParam(value="data") String data, @HeaderParam(value="User-Agent") String header) {
        SubjectsDTO s = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        Date birthdate = this.getFormattedBirthDate(header, s.getBirthday());
        s.setBirthdate(birthdate);
        s = this.service.updateSubject(s, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)s);
    }

    public Date getFormattedBirthDate(String header, String date) {
        int verOffset = header.indexOf("MSIE");
        String fullVersion = header.substring(verOffset + 5, verOffset + 8);
        if (verOffset != -1 && fullVersion != null) {
            return DateUtility.parse(DateUtility.ie8SubjectDate(), date.replace("GMT-", "UTC-"));
        }
        return DateUtility.parse(DateUtility.subjectDate(), date.replace("GMT-", "UTC-"));
    }

    @POST
    @Path(value="/changeSubjectStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String changeSubjectStatus(@FormParam(value="data") String data) {
        SubjectsDTO s = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        BooleanResultDTO result = this.service.changeSubjectStatus(s.getId(), this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }
}

