/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.Ostermiller.util.RandPass;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.LoginDTO;
import edu.harvard.catalyst.scheduler.dto.PasswordResetDTO;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.UserDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetUsersResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDetailResponse;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.security.SchedulerUserDetails;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ServiceHelpers;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.OneWayPasswordEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.stereotype.Component;

@Component
public class AuthService
implements ServiceHelpers {
    private final MailHandler mailHandler;
    private final AuthDAO authDAO;
    private final StudyDAO studyDAO;
    private final ResourceDAO resourceDAO;
    private final AuditService auditService;
    private static final Logger LOGGER = Logger.getLogger(AuthService.class);
    private static final int MIN_PASSWORD_LENGTH = 8;
    static final String NEW_USER_MESSAGE_START = "\n<html><head><title>%1s</title><style></style>\n</head>\n<body><p>Welcome to the CRC Scheduler.</p>\n<p><strong>%2s %3s,<strong></p>\n";
    static final String NEW_USER_MESSAGE_OPTIONAL_MIDDLE = "<p>You will have access to the system once approved by the Super Admin. Please wait for the final confirmation.</p>\n ";
    static final String NEW_USER_MESSAGE_END = "<p> You can go to %4s and click on the \"forgot password\" link to create a new random password.</p>\n <p>This will be emailed to you and then you may change your password once you have logged in.</p>\n</body>\n</html>\n";
    static final String MAIL_ADMIN_MESSAGE = "<html><head><title></title><style></style></head><body><p><strong>%1s %2s has registered.<strong></p>\n <p> You can go to %3s and activate the user.</p>\n<p>The user will be notified of their access to the system once the account is activated.</p>\n</body>\n</html>\n";

    @Autowired
    public AuthService(AuthDAO authDAO, StudyDAO studyDAO, ResourceDAO resourceDAO, AuditService auditService, MailHandler mailHandler) {
        this.authDAO = authDAO;
        this.studyDAO = studyDAO;
        this.resourceDAO = resourceDAO;
        this.auditService = auditService;
        this.mailHandler = mailHandler;
    }

    AuthService() {
        this(null, null, null, null, null);
    }

    SchedulerUserDetails authenticateUser(String username, String password, String httpSession, String ipAddress) {
        User user = this.authDAO.authenticate(username, password, httpSession);
        if (user == null) {
            throw new BadCredentialsException("Invalid Username or Password");
        }
        if (!user.getActive()) {
            throw new DisabledException("User inactive");
        }
        user.setAuthStatus(1);
        UserSession userSession = this.authDAO.createUserSession(httpSession, ipAddress, user);
        return new SchedulerUserDetails(user, userSession);
    }

    String generatePassword() {
        String alphabet = "$%!@#^&?";
        int n = "$%!@#^&?".length();
        Random r = new Random();
        return new RandPass().getPass(8) + "$%!@#^&?".charAt(r.nextInt(n));
    }

    public boolean doPasswordReset(PasswordResetDTO passwordResetDTO) {
        User user = this.authDAO.findUserByEmail(passwordResetDTO.getEmail());
        if (user != null) {
            String newPassword = this.generatePassword();
            String newSalt = UUID.randomUUID().toString();
            String encodedPassword = OneWayPasswordEncoder.getInstance().encode(newPassword, newSalt);
            user.setPassword(encodedPassword);
            user.setSalt(newSalt);
            this.authDAO.updateEntity(user);
            StringBuilder contentSb = new StringBuilder();
            String subject = "Password Reset for " + user.getFirstName() + " " + user.getLastName();
            contentSb.append("\n<html><head><title>").append(subject).append("</title><style></style>\n</head>\n<body>");
            contentSb.append("<p><strong>").append(user.getFirstName()).append(user.getLastName()).append("<strong></p>\n");
            contentSb.append("<p>Your password has been reset to: ").append(newPassword).append("</p>\n");
            contentSb.append("</body>\n").append("</html>\n");
            contentSb.append(subject).append("\n").append(user.getFirstName()).append(" ").append(user.getLastName()).append("\nYour password has been reset to:").append(newPassword);
            this.mailHandler.sendMandatoryEmails(new MailMessageBuilder().to(user.getEmail()).subject(subject).text(contentSb.toString()).build());
        }
        return user != null;
    }

    public UserDTO doRegisterUser(UserDTO dto, String remoteHost) {
        User user = new User();
        if (!this.testPassword(dto.getPassword())) {
            dto.setResult(false);
            dto.setErrorMsg("Insufficient Password");
            return dto;
        }
        this.setupUser(dto, user, InstitutionRoleType.ROLE_STUDY_STAFF);
        if (!dto.isResult()) {
            return dto;
        }
        this.auditService.logUserActivity(remoteHost, user, user, "CREATE USER", null, null);
        return dto;
    }

    public UserDTO sendRegistrationEmail(UserDTO dto, String contextPath, String serverName, int serverPort) {
        User user = this.authDAO.findById(User.class, dto.getId());
        String url = this.makeUrl(contextPath, serverName, serverPort);
        List<User> superAdmins = this.authDAO.findSuperAdminByInstitutionRole();
        String superAdminSubject = "New User Registered: " + user.getFirstName() + " " + user.getLastName();
        String subject = this.makeEmailUserSubject(user);
        superAdmins.stream().map(this.toMessage(superAdminSubject, this.makeNewUserAdminMessage(user, url))).forEach(this.mailHandler::sendMandatoryEmails);
        SimpleMailMessage message = this.toMessage(subject, this.makeNewUserMessage(subject, user, url, true)).apply(user);
        this.mailHandler.sendMandatoryEmails(message);
        return dto;
    }

    String makeUrl(String contextPath, String serverName, int serverPort) {
        return "https://" + serverName + ":" + serverPort + contextPath;
    }

    String makeEmailUserSubject(User user) {
        return "Welcome " + user.getFirstName() + " " + user.getLastName();
    }

    private void setupUser(UserDTO dto, User user, InstitutionRoleType institutionRoleType) {
        if (this.isBadEmailOrEcommonsId(dto)) {
            return;
        }
        String salt = UUID.randomUUID().toString();
        user.setSalt(salt);
        String encodedPassword = OneWayPasswordEncoder.getInstance().encode(dto.getPassword(), salt);
        user.setPassword(encodedPassword);
        InstitutionRoleType roleType = null != institutionRoleType ? institutionRoleType : dto.getInstitutionRoleType();
        this.setSomeUserProperties(dto, user, roleType);
        this.authDAO.createEntity(user);
        if (user.getId() != null) {
            dto.setId(user.getId());
        }
        dto.setResult(true);
    }

    String makeNewUserMessage(String subject, User user, String url, boolean addSuperUserSentence) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_USER_MESSAGE_START);
        if (addSuperUserSentence) {
            sb.append(NEW_USER_MESSAGE_OPTIONAL_MIDDLE);
        }
        sb.append(NEW_USER_MESSAGE_END);
        return String.format(sb.toString(), subject, user.getFirstName(), user.getLastName(), url);
    }

    String makeNewUserAdminMessage(User user, String url) {
        return String.format(MAIL_ADMIN_MESSAGE, user.getFirstName(), user.getLastName(), url);
    }

    private Function<User, SimpleMailMessage> toMessage(String subject, String body) {
        return u -> new MailMessageBuilder().to(u.getEmail()).subject(subject).text(body).build();
    }

    public GetUsersResponse getUsers(SearchDTO searchDTO, String sortBy, String orderBy, int page, int maxResults, String ipAddress, User user) {
        List<SearchDTO.SearchItem> searchItems;
        this.auditService.logViewActivity(ipAddress, user, "All Users Viewed.");
        if (searchDTO != null && (searchItems = searchDTO.getSearchItems()) != null && searchItems.size() > 0) {
            searchItems = searchItems.stream().map(si -> {
                if (si.getKey().equals("u.primaryPhone")) {
                    MiscUtil.preparePhoneNumberSearchItems(si);
                }
                return si;
            }).collect(Collectors.toList());
            searchDTO.setSearchItems(searchItems);
        }
        GetUsersResponse users = this.authDAO.getUsers(searchDTO, sortBy, orderBy, page, maxResults);
        return users;
    }

    BooleanResultDTO checkEcommonsId(LoginDTO loginDTO) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(this.authDAO.checkEcommonsId(loginDTO.getEcommonsId()));
        return booleanResultDTO;
    }

    BooleanResultDTO checkEmail(LoginDTO loginDTO) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(this.authDAO.checkEmail(loginDTO.getEmail()));
        return booleanResultDTO;
    }

    public UserDTO createUser(UserDTO dto, User creatingUser, String contextPath, String remoteHost, String serverName, int serverPort) {
        User user = new User();
        if (dto.isGenerateNewPassword()) {
            dto.setPassword(this.generatePassword());
        } else if (!this.testPassword(dto.getPassword())) {
            dto.setResult(false);
            dto.setErrorMsg("Insufficient Password");
            return dto;
        }
        this.setupUser(dto, user, null);
        if (!dto.isResult()) {
            return dto;
        }
        String url = this.makeUrl(contextPath, serverName, serverPort);
        String subject = this.makeEmailUserSubject(user);
        String emailContent = this.makeNewUserMessage(subject, user, url, false);
        this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(user.getEmail()).subject(subject).text(emailContent).build());
        this.auditService.logUserActivity(remoteHost, user, creatingUser, "CREATE USER", null, null);
        return dto;
    }

    public UserDTO updatePassword(UserDTO dto, User usr) {
        User user = this.authDAO.findUserById(usr.getId());
        if (!this.testPassword(dto.getPassword())) {
            dto.setErrorMsg("Insufficient Password");
            dto.setResult(false);
            return dto;
        }
        String encodedPassword = this.encodePassword(dto, user);
        dto.setPassword(encodedPassword);
        user.setPassword(dto.getPassword());
        this.authDAO.updateEntity(user);
        dto.setResult(true);
        return dto;
    }

    boolean isValidUser(User user, UserDTO dto) {
        boolean result = true;
        if (!this.compareEcommonsIds(dto, user) && !this.checkEcommonsId(dto)) {
            dto.setResult(false);
            dto.setErrorMsg("Ecommons ID already in system");
            result = false;
        } else if (!this.compareEmails(dto, user) && !this.checkEmail(dto)) {
            dto.setResult(false);
            dto.setErrorMsg("Email already in system");
            result = false;
        }
        return result;
    }

    boolean processPassword(User user, UserDTO dto) {
        if (AuthService.hasPassword(dto)) {
            if (!this.passwordsMatch(dto, user)) {
                if (!this.testPassword(dto.getPassword())) {
                    dto.setErrorMsg("Insufficient Password");
                    dto.setResult(false);
                    return false;
                }
                dto.setPassword(this.encodePassword(dto, user));
            }
            user.setPassword(dto.getPassword());
        }
        return true;
    }

    public UserDTO updateUser(UserDTO dto, User creatingUser, String ipAddress) {
        User user = this.authDAO.findUserById(dto.getId());
        InstitutionRoleType institutionRoleType = dto.getInstitutionRoleType();
        if (!this.isValidUser(user, dto)) {
            return dto;
        }
        if (!this.processPassword(user, dto)) {
            return dto;
        }
        this.logUpdateUserData(dto, creatingUser, ipAddress, user, institutionRoleType);
        this.setSomeUserProperties(dto, user, institutionRoleType);
        this.authDAO.updateEntity(user);
        dto.setResult(true);
        return dto;
    }

    private boolean checkEmail(UserDTO dto) {
        return this.authDAO.checkEmail(dto.getEmail());
    }

    private boolean compareEmails(UserDTO dto, User user) {
        return dto.getEmail().equals(user.getEmail());
    }

    private String encodePassword(UserDTO dto, User user) {
        return OneWayPasswordEncoder.getInstance().encode(dto.getPassword(), user.getSalt());
    }

    private boolean checkEcommonsId(UserDTO dto) {
        return this.authDAO.checkEcommonsId(dto.getEcommonsId());
    }

    boolean compareEcommonsIds(UserDTO dto, User user) {
        return dto.getEcommonsId().equals(user.getEcommonsId());
    }

    boolean passwordsMatch(UserDTO dto, User user) {
        return user.getPassword().equals(dto.getPassword());
    }

    static boolean hasPassword(UserDTO dto) {
        String password = dto.getPassword();
        return MiscUtil.isNonNullNonEmpty(password);
    }

    private void logUpdateUserData(UserDTO dto, User creatingUser, String ipAddress, User user, InstitutionRoleType institutionRoleType) {
        String institutionRole = this.studyDAO.findInstitutionRoleByType(institutionRoleType).getName();
        String role = this.lookupFieldById(dto.getRoleId(), this.studyDAO::findRoleById);
        String institution = this.lookupFieldById(dto.getInstitutionId(), this.resourceDAO::findInstitutionById);
        ArrayList previousDataComponents = Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("First Name", dto.getFirstName(), user.getFirstName()), this.makeFieldString("Middle Name", dto.getMiddleName(), user.getMiddleName()), this.makeFieldString("Last Name", dto.getLastName(), user.getLastName()), this.makeFieldString("Ecommons Id", dto.getEcommonsId(), user.getEcommonsId()), this.makeFieldString("Primary Phone", dto.getPrimaryPhone(), user.getPrimaryPhone()), this.makeFieldString("Institution Role", institutionRole, user.getInstitutionRole(), institutionRoleType, InstitutionRole::getType), this.makeFieldString("Role", role, user.getRole(), dto.getRoleId(), Role::getType), this.makeFieldString("Institution", institution, user.getInstitution(), dto.getInstitutionId(), BaseEntity::getId), this.makeFieldString("Notification Email", dto.getNotificationEmail(), user.getNotificationEmail())});
        ArrayList otherPreviousDataComponents = Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("Secondary Phone", dto.getSecondaryPhone(), user.getSecondaryPhone()), this.makeFieldString("Email", dto.getEmail(), user.getEmail()), this.makeFieldString("Fax", dto.getFax(), user.getFax()), this.makeFieldString("Pager", dto.getPager(), user.getPager()), this.makeFieldString("Division", dto.getDivision(), user.getDivision()), this.makeFieldString("Department", dto.getDepartment(), user.getDepartment()), this.makeFieldString("Credential", dto.getCredential(), user.getCredential()), this.makeFieldString("Faculty Rank", dto.getFacultyRank(), user.getFacultyRank())});
        Joiner joiner = Joiner.on((String)"");
        String previousData = joiner.join((Iterable)ListUtils.flatten((List)previousDataComponents));
        String otherPreviousData = joiner.join((Iterable)ListUtils.flatten((List)otherPreviousDataComponents));
        this.auditService.logUserActivity(ipAddress, user, creatingUser, "UPDATE USER", previousData, otherPreviousData);
    }

    UserDTO logViewUser(UserDTO dto, User creatingUser, String ipAddress) {
        User user = this.authDAO.findUserById(dto.getId());
        this.auditService.logUserActivity(ipAddress, user, creatingUser, "VIEW USER", null, null);
        return dto;
    }

    boolean testPassword(String password) {
        if (password.length() < 8) {
            LOGGER.info((Object)"Submitted passwords is not at least eight characters long");
            return false;
        }
        Pattern lowerCasePattern = Pattern.compile("[a-z]+");
        Matcher lowerCaseMatcher = lowerCasePattern.matcher(password);
        Pattern upperCasePattern = Pattern.compile("[A-Z]+");
        Matcher upperCaseMatcher = upperCasePattern.matcher(password);
        if (!lowerCaseMatcher.find() || !upperCaseMatcher.find()) {
            LOGGER.info((Object)"Sumitted passwords does not include at least one uppercase and one lowercase letter");
            return false;
        }
        Pattern numericPattern = Pattern.compile("\\d+");
        Matcher numericMatcher = numericPattern.matcher(password);
        Pattern punctuationPattern = Pattern.compile("\\p{Punct}+");
        Matcher punctuationMatcher = punctuationPattern.matcher(password);
        if (!numericMatcher.find() || !punctuationMatcher.find()) {
            LOGGER.info((Object)"Submitted passwords does not include at least one numeric character and one punctuation character");
            return false;
        }
        return true;
    }

    public BooleanResultDTO changeUserStatus(int userId, User creatingUser, String contextPath, String remoteHost, String serverName, int serverPort) {
        String url = this.makeUrl(contextPath, serverName, serverPort);
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        User users = this.authDAO.findUserById(userId);
        if (users.getActive()) {
            users.setActive(Boolean.FALSE);
            this.authDAO.updateEntity(users);
            this.auditService.logUserActivity(remoteHost, users, creatingUser, "DEACTIVATE USER", null, null);
        } else {
            users.setActive(Boolean.TRUE);
            this.authDAO.updateEntity(users);
            this.auditService.logUserActivity(remoteHost, users, creatingUser, "ACTIVATE USER", null, null);
            this.sendUserActivationEmail(url, users);
        }
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    void sendUserActivationEmail(String url, User users) {
        StringBuffer contentSB = new StringBuffer();
        String subject = "Welcome to the CRC Scheduler,  " + users.getFirstName() + " " + users.getLastName() + " !";
        contentSB.append("\n<html><head><title>" + subject + "</title><style></style>\n</head>\n<body>");
        contentSB.append("\n<p>Welcome to the CRC Scheduler,</p> " + users.getFirstName() + " " + users.getLastName() + "! \n<p>Your account has been activated and you can now access the system. </p>\n<p> You can go to " + url + " and login as " + users.getEcommonsId() + " with the password you entered in the Registration form.  If you ever forget your password, you can click on the \"Forgot My Password\" link and submit your email address. </p>\n<p>A new password will then be emailed to you. Once you are logged in, you can always reset your password on the Management page. </p>\n Thanks!</body>\n</html>\n");
        this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(users.getEmail()).subject(subject).text(contentSB.toString()).build());
    }

    public List<Role> getRoles() {
        return this.authDAO.getRolesExceptFinalApprover();
    }

    boolean isBadEmailOrEcommonsId(UserDTO dto) {
        if (!this.checkEcommonsId(dto)) {
            dto.setResult(false);
            dto.setErrorMsg("Ecommons ID already in system");
            return true;
        }
        if (!this.checkEmail(dto)) {
            dto.setResult(false);
            dto.setErrorMsg("Email already in system");
            return true;
        }
        return false;
    }

    void setSomeUserProperties(UserDTO dto, User user, InstitutionRoleType institutionRoleType) {
        user.setEcommonsId(dto.getEcommonsId());
        user.setFirstName(dto.getFirstName());
        user.setMiddleName(dto.getMiddleName());
        user.setLastName(dto.getLastName());
        user.setPrimaryPhone(dto.getPrimaryPhone());
        user.setSecondaryPhone(dto.getSecondaryPhone());
        user.setEmail(dto.getEmail());
        user.setNotificationEmail(dto.getNotificationEmail());
        user.setFax(dto.getFax());
        user.setPager(dto.getPager());
        user.setDivision(this.authDAO.findDivisionById(dto.getDivision()));
        user.setDepartment(this.authDAO.findDepartmentById(dto.getDepartment()));
        user.setInstitutionRole(this.studyDAO.findInstitutionRoleByType(institutionRoleType));
        user.setRole(this.studyDAO.findRoleById(dto.getRoleId()));
        user.setInstitution(this.resourceDAO.findInstitutionById(dto.getInstitutionId()));
        user.setCredential(this.authDAO.findCredentialById(dto.getCredential()));
        user.setFacultyRank(this.authDAO.findFacultyRankById(dto.getFacultyRank()));
        user.setActive(dto.isActive());
    }

    public List<UserDataResponse> getStudyMembers(String filterString, String sortBy, String orderBy) {
        return this.authDAO.getAddStudyMemberList(filterString, sortBy, orderBy);
    }

    public UserDetailResponse getUserData(int userId) {
        return this.authDAO.getUserData(userId);
    }
}

