/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var userToDeactivate;
var userToActivate;

var sortByLastName = "u.lastName";
var sortByFirstName = "u.firstName";
var sortByContactNumber = "u.primaryPhone";
var sortByEcommons = "u.ecommonsId";
function loadUserData(currentPage) {
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 50;
    }

    var filterString = $.trim($("#filters_string").val());
    $.getJSON("rest/management/getUsers?filterString=" + filterString + "&page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 50) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByLastName), function (data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var lastName_header1 = 'sortable';
        var firstName_header2 = 'sortable';
        var contact_header3 = 'sortable';
        var ecommons_header4 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByLastName) {
            lastName_header1 = sort_header;
        } else if (sortBy == sortByFirstName) {
            firstName_header2 = sort_header;
        } else if (sortBy == sortByContactNumber) {
            contact_header3 = sort_header;
        } else if (sortBy == sortByEcommons) {
            ecommons_header4 = sort_header;
        }

        var out =
            " <table id='users'>" +
            "  <tr>" +
            "   <td class= " + lastName_header1 + " onclick='sortingFunction(sortByLastName)'><strong>Last Name</strong></td> " +
            "   <td class= " + firstName_header2 + " onclick='sortingFunction(sortByFirstName)'><strong>First Name</strong></td>" +
            "   <td class= " + contact_header3 + " onclick='sortingFunction(sortByContactNumber)'><strong>Primary Contact Number&nbsp;</strong></td>" +
            "   <td class= " + ecommons_header4 + " onclick='sortingFunction(sortByEcommons)'><strong>User ID</strong></td>" +
            "   <td class='not_sortable shortFixedLinkColWidth'><strong>Status</strong></td>" +
            "   <td class='not_sortable shortFixedLinkColWidth'><strong></strong></td>" +
            "  </tr> ";

        $.each(data.users, function (key, val) {
            totalData = data.total;

            out += "<tr>";
            out += "   <td>" + val.lastName + "</td>" +
                "          <td>" + val.firstName + "</td>" +
                "          <td>" + val.primaryPhone + "</td>" +
                "          <td>" + val.ecommonsId + "</td>" +
                "          <td>" + " <a href='javascript:userChangeStatusConfirmation(" + val.id + ")'>" + statusValue(val.active) + "</a>" + "</td>" +
                "	   <td>" + " <a href='javascript:showUserDetail(" + val.id + ")'>View Detail</a>" + "</td>" +
                " </tr>";
            iteration++;
        });

        out += "  </table>";

        setupTable(out, $('#userDataTable'), currentPage, totalData);
    });
}


