/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl;

import edu.harvard.med.countway.dl.Constants;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

public class SolrIndexer {
    private SolrIndexer() {
    }

    public static void main(String[] args) throws Exception {
        String usage = "java " + SolrIndexer.class.getCanonicalName();
        CommonsHttpSolrServer server = new CommonsHttpSolrServer(Constants.SOLR_URL);
        Date start = new Date();
        System.out.println("Indexing from " + Constants.DB_URL + " to solr instance '" + Constants.SOLR_URL + "'...");
        System.out.println("Deleting...");
        server.deleteByQuery("*:*");
        System.out.println("Indexing...");
        int rowct = SolrIndexer.indexResources((SolrServer)server);
        System.out.println("Indexed " + rowct + " resources");
        System.out.println("Optimizing...");
        server.optimize();
        System.out.println("Commiting...");
        server.commit();
        Date end = new Date();
        System.out.println(end.getTime() - start.getTime() + " total milliseconds");
    }

    private static int indexResources(SolrServer server) throws Exception {
        Class.forName(Constants.DB_DRIVER).newInstance();
        Connection conn = DriverManager.getConnection(Constants.DB_URL, Constants.DB_USER, Constants.DB_PASS);
        PreparedStatement stmt = conn.prepareStatement("select id,title,title_idx,aleph_num,url,toc_feed_url,description,access,is_historical from cdl2_resource");
        ResultSet rs = stmt.executeQuery();
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        int rowct = 0;
        while (rs.next()) {
            ++rowct;
            int id = rs.getInt(1);
            String idstr = Integer.toString(id);
            String title = rs.getString(2);
            String title_idx = rs.getString(3);
            String aleph_num = rs.getString(4);
            String url = rs.getString(5);
            String toc_feed_url = rs.getString(6);
            String description = rs.getString(7);
            String access = rs.getString(8);
            boolean historical = rs.getBoolean(9);
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", (Object)idstr);
            doc.addField("title", (Object)title, 2.0f);
            doc.addField("title_idx", (Object)title_idx.toLowerCase());
            if (aleph_num != null) {
                doc.addField("aleph_num", (Object)aleph_num);
            }
            doc.addField("url", (Object)url);
            doc.addField("toc_feed_url", (Object)toc_feed_url);
            if (description != null) {
                doc.addField("description", (Object)description);
            }
            doc.addField("access", (Object)access);
            doc.addField("historical", (Object)(historical ? "true" : "false"));
            PreparedStatement tidstmt = conn.prepareStatement("select type_id from cdl2_resource_resourcetype where resource_id = ?");
            tidstmt.setInt(1, id);
            ResultSet tidrs = tidstmt.executeQuery();
            while (tidrs.next()) {
                String typeidstr = Integer.toString(tidrs.getInt(1));
                doc.addField("type_id", (Object)typeidstr);
            }
            tidrs.close();
            tidstmt.close();
            PreparedStatement subjstmt = conn.prepareStatement("select distinct cdl2_subject.subject from cdl2_resource_subject\ninner join cdl2_subject on cdl2_subject.id = cdl2_resource_subject.subject_id\nand cdl2_resource_subject.resource_id = ?");
            subjstmt.setInt(1, id);
            ResultSet subjrs = subjstmt.executeQuery();
            while (subjrs.next()) {
                String subj = subjrs.getString(1);
                doc.addField("subject", (Object)subj);
            }
            subjrs.close();
            subjstmt.close();
            docs.add(doc);
        }
        rs.close();
        stmt.close();
        conn.close();
        server.add(docs);
        return rowct;
    }

    static {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }
}

