package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.LoginType;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;

public abstract class AbstractServlet extends HttpServlet
{
    private static final long serialVersionUID = -6086718566583482702L;
    private static final Logger log = Logger.getLogger(AbstractServlet.class);
    
    public void doPost(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        doGet(request, response);
    }
    
    protected static void setDummySessionAttributes(HttpServletRequest request)
    {
        if (CountwayConfig.getProperty(PropertyKey.DUMMY_SESSION).equals("true"))
        {
            HttpSession session = request.getSession();
            session.setAttribute("uid", "ddh4");
            session.setAttribute("loginType", LoginType.ecid);
            session.setAttribute("firstName", "David");
            session.setAttribute("lastName", "Hummel");
            session.setAttribute("name", "David Hummel");
            session.setAttribute("email", "lemmuh@gmail.com");
            if (request.getParameter("dluid") != null)
            {
                session.setAttribute("dluid", Integer.parseInt(request.getParameter("dluid")));
            }
            else if (request.getParameter("dluid") == null && session.getAttribute("dluid") == null)
            {
                session.setAttribute("dluid", 25277);
            }
            session.setAttribute("dlaccess", "true");
        }
    }
}
