package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

public class AhdServlet extends AbstractServlet
{
    private static final long serialVersionUID = -8450900014996732525L;
    private static final Logger log = Logger.getLogger(AhdServlet.class);
    
    private static final String loginUrl = "../login.html?url=dl/ahd.html";
    private static final String jspUrl = "ahd.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        setDummySessionAttributes(request);
        final HttpSession session = request.getSession();
        final String uid = (String) session.getAttribute("uid");
        if (uid == null || uid.trim().equals(""))
        {
            request.setAttribute("display", false);
            response.sendRedirect(loginUrl);
        }
        else
        {
            request.setAttribute("display", true);
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
    }
}
