package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;
import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.CourseBuildingDAO;
import edu.harvard.med.countway.dl.dao.CourseTypeDAO;
import edu.harvard.med.countway.dl.model.SelectClassListParams;
import edu.harvard.med.countway.tools.IntegerUtil;

public class ClassesServlet extends AbstractServlet
{
    private static final long serialVersionUID = 945717297527766341L;
    private static final Logger log = Logger.getLogger(ClassesServlet.class);
    
    private static final String countwayInstitutionIdString = CountwayConfig.getProperty(PropertyKey.COUNTWAY_INSTITUTION_ID);
    private static final String jspUrl = "classes.jspx";
    private static final String errorUrl = "../../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        try
        {
            Integer countwayInstitutionId = Integer.parseInt(countwayInstitutionIdString);
            setDummySessionAttributes(request);
            ClassDAO classDao = new ClassDAO();
            CourseTypeDAO courseTypeDao = new CourseTypeDAO();
            CourseBuildingDAO courseBuildingDao = new CourseBuildingDAO();
            // request params
            String institutionId = request.getParameter("institutionId");
            String[] typeId = request.getParameterValues("typeId");
            String[] buildingId = request.getParameterValues("buildingId");
            String query = request.getParameter("query");
            String search = request.getParameter("search");
            request.setAttribute("countwayInstitutionId", countwayInstitutionId);
            request.setAttribute("courseTypeList", courseTypeDao.selectCourseTypeList());
            request.setAttribute("courseBuildingList", courseBuildingDao.selectCourseBuildingList());
            SelectClassListParams select = new SelectClassListParams();
            if (search != null)
            {
                if (institutionId != null && IntegerUtil.isValidInteger(institutionId) && Integer.parseInt(institutionId) == countwayInstitutionId)
                {
                    select.setInstitutionId(new Integer[] {countwayInstitutionId});
                }
                if (typeId != null && typeId.length != 0)
                {
                    List<Integer> newTypeId = new ArrayList<Integer>();
                    for (String tid: typeId)
                    {
                        if (tid != null && tid.equals("0"))
                        {
                            newTypeId.clear();
                            break;
                        }
                        else if (tid != null && IntegerUtil.isValidInteger(tid) && courseTypeDao.courseTypeExists(Integer.parseInt(tid)))
                        {
                            newTypeId.add(Integer.parseInt(tid));
                        }
                    }
                    select.setTypeId(newTypeId);
                }
                if (buildingId != null && buildingId.length != 0)
                {
                    List<Integer> newBuildingId = new ArrayList<Integer>();
                    for (String bid: buildingId)
                    {
                        if (bid != null && bid.equals("0"))
                        {
                            newBuildingId.clear();
                            break;
                        }
                        else if (bid != null && IntegerUtil.isValidInteger(bid) && courseBuildingDao.courseBuildingExists(Integer.parseInt(bid)))
                        {
                            newBuildingId.add(Integer.parseInt(bid));
                        }
                    }
                    select.setBuildingId(newBuildingId);
                }
                if (query != null && !query.trim().equals(""))
                {
                    select.setQuery(query);
                }
            }
            select.setActive(true);
            select.setFuture(true);
            select.setNow(new Date());
            select.setSort(SelectClassListParams.Sort.Title);
            request.setAttribute("classList", classDao.selectClassList(select));
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
    }
}
