package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.UserResourceDAO;
import edu.harvard.med.countway.dl.model.Resource;
import edu.harvard.med.countway.dl.model.User;
import edu.harvard.med.countway.dl.model.UserResource;
import edu.harvard.med.countway.tools.IntegerUtil;

public class MydlServlet extends AbstractServlet
{
    private static final long serialVersionUID = -3696987136139567861L;
    private static final Logger log = Logger.getLogger(MydlServlet.class);
    
    private static final String loginUrl = "../login.html?url=dl/mydl.html";
    private static final String jspUrl = "mydl.jspx";
    private static final String errorUrl = "../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        // TODO: pass collection to userResourceDao for insertion/deletion
        try
        {
            setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            UserResourceDAO userResourceDao = new UserResourceDAO();
            // session vars
            Integer dluid = (Integer) session.getAttribute("dluid");
            String uid = (String) session.getAttribute("uid");
            // request params
            // for ecommons view
            String view = request.getParameter("view");
            // insert
            String insert = request.getParameter("insert");
            String[] resourceId = request.getParameterValues("resourceId");
            // delete
            String delete = request.getParameter("delete");
            String[] userResourceId = request.getParameterValues("userResourceId");
            // user messages
            List<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals(""))
            {
                String url = loginUrl;
                if (view != null && view.equals("ec"))
                {
                    url += "%3Fview=ec";
                }
                response.sendRedirect(url);
                return;
            }
            if (insert != null)
            {
                if (resourceId != null && resourceId.length > 0)
                {
                    final Collection<UserResource> userResourceList = new ArrayList<UserResource>();
                    for (final String rid: resourceId)
                    {
                        if (!rid.trim().equals("") && IntegerUtil.isValidInteger(rid))
                        {
                            final User user = new User();
                            user.setId(dluid);
                            final Resource resource = new Resource();
                            resource.setId(Integer.parseInt(rid));
                            final UserResource userResource = new UserResource();
                            userResource.setUser(user);
                            userResource.setResource(resource);
                            userResourceList.add(userResource);
                        }
                    }
                    final Integer insertCount = userResourceDao.insertUserResource(userResourceList);
                    if (insertCount > 0)
                    {
                        messages.add("Successfully added "+insertCount+" new Resource(s)");
                    }
                }
            }
            if (delete != null)
            {
                if (userResourceId != null && userResourceId.length > 0)
                {
                    final Collection<UserResource> userResourceList = new ArrayList<UserResource>();
                    for (String urid: userResourceId)
                    {
                        if (!urid.trim().equals("") && IntegerUtil.isValidInteger(urid))
                        {
                            // only delete resources for the logged in user
                            UserResource userResource = userResourceDao.selectUserResource(Integer.parseInt(urid));
                            if (userResource != null && userResource.getUser().getId().equals(dluid))
                            {
                                userResourceList.add(userResource);
                            }
                        }
                    }
                    final Integer deleteCount = userResourceDao.deleteUserResource(userResourceList);
                    if (deleteCount > 0)
                    {
                        messages.add("Successfully deleted "+deleteCount+" Resource(s)");
                    }
                }            
            }
            request.setAttribute("messages", messages);
            request.setAttribute("userResourceList", userResourceDao.selectUserResourceListByUserId(dluid));
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
    }
}
