package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.TocFeedDAO;

public class MyfeedsServlet extends AbstractServlet
{
    private static final long serialVersionUID = 913700366362546444L;
    private static final Logger log = Logger.getLogger(MyfeedsServlet.class);
    
    private static final String loginUrl = "../login.html?url=dl/myfeeds.html";
    private static final String jspUrl = "myfeeds.jspx";
    private static final String errorUrl = "../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        try
        {
            setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            TocFeedDAO dao = new TocFeedDAO();
            // session vars
            Integer dluid = (Integer) session.getAttribute("dluid");
            String uid = (String) session.getAttribute("uid");
            // for ecommons view
            String view = request.getParameter("view");
            if (uid == null || uid.trim().equals(""))
            {
                String url = loginUrl;
                if (view != null && view.equals("ec"))
                {
                    url += "%3Fview=ec";
                }
                response.sendRedirect(url);
                return;
            }
            request.setAttribute("tocFeedList", dao.selectTocFeedListByUserId(dluid));
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
    }
}
