package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

import edu.harvard.med.countway.dl.dao.PubmedSearchResultDAO;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.ncbi.Eutil.EutilException;

public class QuicksearchServlet extends AbstractServlet
{
    private static final long serialVersionUID = 4484470534700402765L;
    private static final Logger log = Logger.getLogger(QuicksearchServlet.class);
    
    private static final String jspUrl = "quicksearch.jspx";
    private static final String errorUrl = "../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        try
        {
            PubmedSearchResultDAO pubmedDao = new PubmedSearchResultDAO();
            ResourceDAO resourceDao = new ResourceDAO();
            // request params
            String query = request.getParameter("query");
            String search = request.getParameter("search");
            if (search != null)
            {
                // get pubmed results
                log.debug("getting pubmed results...");
                request.setAttribute("pubmedSearchResultList", pubmedDao.selectPubmedSearchResultList(query, 10));
                
                // get resource results
                log.debug("getting resource results...");
                SelectResourceListParams select = new SelectResourceListParams();
                if (query != null && !query.trim().equals(""))
                {
                    select.setQuery(query);
                    select.setSort(SelectResourceListParams.Sort.Score);
                }
                else
                {
                    select.setSort(SelectResourceListParams.Sort.Title);
                }
                select.setHistorical(false);
                select.setOffset(0);
                select.setLimit(10);
                
                request.setAttribute("resourceList", resourceDao.selectResourceList(select));
            }
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
        catch (SolrServerException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
        catch (EutilException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);            
        }
    }
}
