package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;
import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.model.ClassUser;
import edu.harvard.med.countway.tools.IntegerUtil;
import edu.harvard.med.countway.tools.MailUtil;
import edu.harvard.med.countway.tools.TemplateUtil;

public class RegistrationsServlet extends AbstractServlet
{
    private static final long serialVersionUID = -5207319248653362642L;
    private static final Logger log = Logger.getLogger(RegistrationsServlet.class);
    
    private static final String loginUrl = "../../../login.html?url=menuNavigation/libraryServices/classes/registrations.html";
    private static final String jspUrl = "registrations.jspx";
    private static final String errorUrl = "../../../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        // TODO: pass collection to classUserDao for deletion
        try
        {
            setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            ClassUserDAO classUserDao = new ClassUserDAO();
            // session vars
            String uid = (String) session.getAttribute("uid");
            Integer dluid = (Integer) session.getAttribute("dluid");
            // request params
            // delete
            String delete = request.getParameter("delete");
            String[] classUserId = request.getParameterValues("classUserId");
            // user messages
            List<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals(""))
            {
                response.sendRedirect(loginUrl);
                return;
            }
            if (delete != null)
            {
                if (classUserId != null && classUserId.length > 0)
                {
                    for (String cuid: classUserId)
                    {
                        if (cuid.trim().equals("") || !IntegerUtil.isValidInteger(cuid) || !classUserDao.classUserExists(Integer.parseInt(cuid)))
                        {
                            continue;
                        }
                        ClassUser classUser = classUserDao.selectClassUser(Integer.parseInt(cuid));
                        // only delete classes for the logged in user
                        if (!classUserDao.classUserExists(classUser.getClazz().getId(),dluid))
                        {
                            continue;
                        }
                        if (classUserDao.deleteClassUser(Integer.parseInt(cuid)) != null)
                        {
                            final String msg = TemplateUtil.getClassRegisterMsg("de-registered", classUser.getClazz().getCourse().getTitle(), classUser.getClazz().getTime(), classUser.getClazz().getLocation().getConcat());
                            messages.add(msg);
                            try
                            {
                                final String to;
                                if (!CountwayConfig.getProperty(PropertyKey.DEPLOY_TIER).equals("prod") &&
                                    !CountwayConfig.getProperty(PropertyKey.DEPLOY_TIER).equals("stage"))
                                {
                                    to = CountwayConfig.getProperty(PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL);
                                }
                                else
                                {
                                    to = classUser.getEmail();
                                }
                                final String emailmsg = TemplateUtil.getClassRegisterEmail("de-registered", classUser.getClazz().getCourse().getTitle(), classUser.getClazz().getTime(), classUser.getClazz().getDuration(), classUser.getClazz().getLocation().getConcat(), request.getScheme(), request.getServerName());
                                MailUtil.sendMail(CountwayConfig.getProperty(PropertyKey.CLASS_NOTIFICATION_FROM_EMAIL), to, "Countway Class De-Registration Notification", emailmsg, CountwayConfig.getProperty(PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL));
                                messages.add("A de-registration confirmation has been e-mailed to: "+to);
                            }
                            catch (IOException e)
                            {
                                messages.add("Error sending de-registration confirmation e-mail");
                            }
                        }
                        else
                        {
                            messages.add("Couldn't de-register you for \""+classUser.getClazz().getCourse().getTitle()+"\"");
                        }
                    }                
                }
            }
            request.setAttribute("messages", messages);
            request.setAttribute("classUserList", classUserDao.selectClassUserListByUserId(dluid));
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
    }
}
