package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.tools.IntegerUtil;

public class ResourceServlet extends AbstractServlet
{
    private static final long serialVersionUID = 4490150836552634373L;
    private static final Logger log = Logger.getLogger(ResourceServlet.class);
    
    private static final String jspUrl = "resource.jspx";
    private static final String errorUrl = "../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        try
        {
            ResourceDAO resourceDao = new ResourceDAO();
            ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
            // request params
            String id = request.getParameter("id");
            // user messages
            List<String> messages = new ArrayList<String>();
            if (id == null || id.trim().equals("") || !IntegerUtil.isValidInteger(id) || !resourceDao.resourceExists(Integer.parseInt(id)))
            {
                messages.add("This resource does not exist or is invalid!");
                request.setAttribute("messages", messages);
            }
            else
            {
                request.setAttribute("resource", resourceDao.selectResource(Integer.parseInt(id)));
                request.setAttribute("resourceTypeList", resourceTypeDao.selectResourceTypeListByResourceId(Integer.parseInt(id)));
            }
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
    }
}
