package edu.harvard.med.countway.dl.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.CountwayConfig.PropertyKey;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.tools.IntegerUtil;

public class ResourcesServlet extends AbstractServlet
{
    private static final long serialVersionUID = -1870608692044548014L;
    private static final Logger log = Logger.getLogger(ResourcesServlet.class);

    private static final String journalResourceTypeIdString = CountwayConfig.getProperty(PropertyKey.JOURNAL_RESOURCE_TYPE_ID);
    private static final String jspUrl = "resources.jspx";
    private static final String errorUrl = "../error.jspx";
    
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException
    {
        try
        {
            Integer journalResourceTypeId = Integer.parseInt(journalResourceTypeIdString);
            setDummySessionAttributes(request);
            ResourceDAO resourceDao = new ResourceDAO();
            ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
            // request params
            String query = request.getParameter("query");
            //String field = request.getParameter("field");
            String[] typeId = request.getParameterValues("typeId");
            String historical = request.getParameter("historical");
            //String sort = request.getParameter("sort");
            String offset = request.getParameter("offset");
            String search = request.getParameter("search");
            request.setAttribute("journalResourceTypeId", journalResourceTypeId);
            request.setAttribute("resourceTypeList", resourceTypeDao.selectResourceTypeList());
            if (search != null)
            {
                SelectResourceListParams select = new SelectResourceListParams();
                if (query != null && !query.trim().equals(""))
                {
                    select.setQuery(query);
                    select.setSort(SelectResourceListParams.Sort.Score);
                }
                else
                {
                    select.setSort(SelectResourceListParams.Sort.Title);
                }
                if (typeId != null && typeId.length != 0)
                {
                    ArrayList<Integer> newTypeId = new ArrayList<Integer>();
                    for (String tid: typeId)
                    {
                        if (tid != null && tid.equals("0"))
                        {
                            newTypeId.clear();
                            break;
                        }
                        else if (tid != null && !tid.trim().equals("") && IntegerUtil.isValidInteger(tid) && resourceTypeDao.resourceTypeExists(Integer.parseInt(tid)))
                        {
                            newTypeId.add(Integer.parseInt(tid));
                        }
                    }
                    select.setTypeId(newTypeId);
                }
                if (historical == null || historical.equals("false"))
                {
                    select.setHistorical(false);
                }
                if (offset != null && !offset.trim().equals("") && IntegerUtil.isValidInteger(offset))
                {
                    select.setOffset(Integer.parseInt(offset));
                }
                else
                {
                    select.setOffset(0);
                }
                request.setAttribute("resourceList", resourceDao.selectResourceList(select));
            }
            request.getRequestDispatcher(jspUrl).forward(request, response);
        }
        catch (SQLException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);
        }
        catch (SolrServerException e)
        {
            request.setAttribute("javax.servlet.error.exception", e);
            request.setAttribute("javax.servlet.jsp.jspException", e);
            request.getRequestDispatcher(errorUrl).forward(request, response);            
        }
    }
}
